<?php
/**
 * Captcha
 */

if(!defined('ABSPATH')) {
	exit;
}

// Enqueue inline scripts
function ejabat_enqueue_captcha_inline_scripts() {
	// Hide captcha for logged in users
	if(get_option('ejabat_captcha_loggedin_hide', true) && is_user_logged_in()) { return; }
	// Switch between the selected captcha type
	switch(get_option('ejabat_captcha_type', 'disabled')) {
	// Google reCAPTCHA
	case 'recaptcha':
		// Enqueue only if has shortcode
		global $post;
		if(is_a($post, 'WP_Post') && (has_shortcode($post->post_content, 'ejabat_register') || has_shortcode($post->post_content, 'ejabat_reset_password') || has_shortcode($post->post_content, 'ejabat_change_email') || has_shortcode($post->post_content, 'ejabat_delete_account') || has_shortcode($post->post_content, 'ejabat_webpresence'))) {
			switch(get_option('ejabat_recaptcha_version')) {
			// reCAPTCHA v2 Checkbox
			case 'v2_checkbox':
				// Auto theme script
				$theme = "";
				if(get_option('ejabat_recaptcha_theme', 'auto') == 'auto') {
					$theme = "if(window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
						document.querySelector('form.ejabat #g-recaptcha').setAttribute('data-theme', 'dark');
					}
					else {
						document.querySelector('form.ejabat #g-recaptcha').setAttribute('data-theme', 'light');
					}";
				}
				$script = "<script type='text/javascript'>
				function grecaptcha_render() {
					setTimeout(() => {
						if(typeof grecaptcha !== 'undefined' && typeof grecaptcha.render !== 'undefined') grecaptcha.render(document.querySelector('form.ejabat #g-recaptcha'));
						else this.grecaptcha_render();
					}, 200);
				}
				document.addEventListener('ejabat_loaded', function() {
					if(document.querySelector('form.ejabat #g-recaptcha')) {
						".$theme."
						grecaptcha_render();
					}
				});
				document.addEventListener('ejabat_submit_error', function() {
					if(document.querySelector('form.ejabat #g-recaptcha')) {
						grecaptcha.reset(document.querySelector('form.ejabat #g-recaptcha'));
					}
				});
				</script>
				<script async defer src='https://www.google.com/recaptcha/api.js?render=explicit'></script>";
				break;
			// reCAPTCHA v2 Invisible
			case 'v2_invisible':
				// Auto theme script
				$theme = "";
				if(get_option('ejabat_recaptcha_theme', 'auto') == 'auto') {
					$theme = "if(window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
						document.querySelector('form.ejabat #g-recaptcha').setAttribute('data-theme', 'dark');
					}
					else {
						document.querySelector('form.ejabat #g-recaptcha').setAttribute('data-theme', 'light');
					}";
				}
				$script = "<script type='text/javascript'>
					function grecaptcha_render() {
						setTimeout(() => {
							if(typeof grecaptcha !== 'undefined' && typeof grecaptcha.render !== 'undefined') grecaptcha.render(document.querySelector('form.ejabat #g-recaptcha'));
							else this.grecaptcha_render();
						}, 200);
					}
					document.addEventListener('ejabat_loaded', function() {
						if(document.querySelector('form.ejabat #g-recaptcha')) {
							".$theme."
							grecaptcha_render();
						}
					});
					document.addEventListener('submit', function(event) {
						if(event.target == document.querySelector('form.ejabat')) {
							if(document.querySelector('form.ejabat #g-recaptcha')) {
								if(!document.querySelector('form.ejabat #g-recaptcha-response').value) {
									event.stopPropagation();
									event.preventDefault();
									grecaptcha.execute(document.querySelector('form.ejabat #g-recaptcha'));
								}
							}
						}
					}, true);
					document.addEventListener('ejabat_submit_error', function() {
						if(document.querySelector('form.ejabat #g-recaptcha')) {
							grecaptcha.reset(document.querySelector('form.ejabat #g-recaptcha'));
						}
					});
					function ejabat_captcha_callback() {
						document.querySelector('form.ejabat').dispatchEvent(
							new Event('submit', {
								'bubbles': true,
								'cancelable': true
							})
						);
					}
				</script>
				<script async defer src='https://www.google.com/recaptcha/api.js?render=explicit'></script>";
				break;
			// reCAPTCHA v3
			case 'v3':
				$site_key = get_option('ejabat_recaptcha_site_key');
				$script = "<script type='text/javascript'>
					document.addEventListener('submit', function(event) {
						if(event.target == document.querySelector('form.ejabat')) {
							if(document.querySelector('form.ejabat #g-recaptcha-response')) {
								if(!document.querySelector('form.ejabat #g-recaptcha-response').value) {
									event.stopPropagation();
									event.preventDefault();
									grecaptcha.execute('$site_key', {action: 'ejabat'}).then(function(token) {
										document.querySelector('form.ejabat #g-recaptcha-response').value = token;
										document.querySelector('form.ejabat').dispatchEvent(
											new Event('submit', {
												'bubbles': true,
												'cancelable': true
											})
										);
									});
								}
							}
						}
					}, true);
					document.addEventListener('ejabat_submit_error', function() {
						if(document.querySelector('form.ejabat #g-recaptcha-response')) {
							document.querySelector('form.ejabat #g-recaptcha-response').value = '';
						}
					});
				</script>
				<script async defer src='https://www.google.com/recaptcha/api.js?render=$site_key'></script>";
				break;
			}
			// Display minified script for better compatibility with cache plugins
			echo \JShrink\Minifier::minify($script);
		}
		break;
	// PHP Captcha
	case 'php':
		// Enqueue only if has shortcode
		global $post;
		if(is_a($post, 'WP_Post') && (has_shortcode($post->post_content, 'ejabat_register') || has_shortcode($post->post_content, 'ejabat_reset_password') || has_shortcode($post->post_content, 'ejabat_change_email') || has_shortcode($post->post_content, 'ejabat_delete_account') || has_shortcode($post->post_content, 'ejabat_webpresence'))) {
			$script = "<script type='text/javascript'>
				document.addEventListener('ejabat_submit_error', function() {
					var request = new XMLHttpRequest();
					request.open('POST', ejabat.rest_api + 'ejabberd-account-tools/v1/captcha', true);
					request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
					request.responseType = 'json';
					request.onload = function() {
						if(this.status == 200) {
							document.querySelector('.ejabat #captcha img').src = this.response.src;
							document.querySelector('.ejabat #captcha input').value = '';
						}
					}
					request.send();
				});
			</script>";
			// Display minified script for better compatibility with cache plugins
			echo \JShrink\Minifier::minify($script);
		}
		break;
	}
}
add_action('wp_print_footer_scripts', 'ejabat_enqueue_captcha_inline_scripts');

// Get captcha field
function ejabat_captcha_field() {
	// Hide captcha for logged in users
	if(get_option('ejabat_captcha_loggedin_hide', true) && is_user_logged_in()) { return; }
	// Switch between the selected captcha type
	switch(get_option('ejabat_captcha_type', 'disabled')) {
	// Google reCAPTCHA
	case 'recaptcha':
		switch(get_option('ejabat_recaptcha_version')) {
		// reCAPTCHA v2 Checkbox
		case 'v2_checkbox':
			$field = '<p id="g-recaptcha" class="g-recaptcha"
				data-sitekey="'.get_option('ejabat_recaptcha_site_key').'"
				data-theme="'.get_option('ejabat_recaptcha_theme', 'auto').'"
				data-size="'.get_option('ejabat_recaptcha_v2_size', 'normal').'">
			</p>';
			break;
		// reCAPTCHA v2 Invisible
		case 'v2_invisible':
			$field = '<p id="g-recaptcha" class="g-recaptcha"
				data-sitekey="'.get_option('ejabat_recaptcha_site_key').'"
				data-theme="'.get_option('ejabat_recaptcha_theme', 'auto').'"
				data-badge="'.get_option('ejabat_recaptcha_v2_badge', 'bottomright').'"
				data-size="invisible"
				data-callback="ejabat_captcha_callback">
			</p>';
			break;
		// reCAPTCHA v3
		case 'v3':
			$field = '<input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response" value=""/>';
			break;
		}
		break;
	// PHP Captcha
	case 'php':
		session_start();
		$phrase = new Gregwar\Captcha\PhraseBuilder(get_option('ejabat_phpcaptcha_length', 5));
		$captcha = new Gregwar\Captcha\CaptchaBuilder(null, $phrase);
		$captcha->build(get_option('ejabat_phpcaptcha_width', 150), get_option('ejabat_phpcaptcha_height', 40));
		$_SESSION['captcha'] = $captcha->getPhrase();
		switch(get_option('ejabat_phpcaptcha_position', 'right')) {
		// On the left
		case 'left':
			$field = '<p id="captcha" class="ejabat-validate">
				<img src="'.$captcha->inline(get_option('ejabat_phpcaptcha_quality', 100)).'" style="float:left; margin-right:10px;"/>
				<input type="text" name="captcha" placeholder="'.__('Captcha code', 'ejabberd-account-tools').'" style="max-width:'.(282-get_option('ejabat_phpcaptcha_width', 150)).'px;">
				<span class="ejabat-tip"></span>
			</p>';
			break;
		// On the right
		case 'right':
			$field = '<p id="captcha" class="ejabat-validate">
				<input type="text" name="captcha" placeholder="'.__('Captcha code', 'ejabberd-account-tools').'" style="float:left; margin-right:10px; max-width:'.(282-get_option('ejabat_phpcaptcha_width', 150)).'px;">
				<img src="'.$captcha->inline(get_option('ejabat_phpcaptcha_quality', 100)).'" />
				<span class="ejabat-tip"></span>
			</p>';
			break;
		}
		break;
	}
	return isset($field) ? $field : '';
}

// Verifying captcha response
function ejabat_captcha_verify($request) {
	// Hide captcha for logged in users
	if(get_option('ejabat_captcha_loggedin_hide', true) && is_user_logged_in()) { return true; }
	// Switch between the selected captcha type
	switch(get_option('ejabat_captcha_type', 'disabled')) {
	// Google reCAPTCHA
	case 'recaptcha':
		// POST arguments
		$args = array(
			'body' => array(
				'secret' => get_option('ejabat_recaptcha_secret_key'),
				'response' => $request['g-recaptcha-response'],
				'remoteip' => $_SERVER['REMOTE_ADDR']
			),
			'redirection' => 0,
			'httpversion' => '1.1'
		);
		// POST data
		$response = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', $args);
		if(is_wp_error($response)) { return false; }
		else {
			switch(get_option('ejabat_recaptcha_version')) {
				// reCAPTCHA v3
				case 'v3':
					if(json_decode($response['body'])->success == false) return false;
					else if(json_decode($response['body'])->score >= get_option('ejabat_recaptcha_v3_threshold', 0.5)) return true;
					else return false;
					break;
				// Other versions
				default:
					return json_decode($response['body'])->success;
					break;
			}
		}
	// PHP Captcha
	case 'php':
		session_start();
		if(Gregwar\Captcha\PhraseBuilder::comparePhrases($_SESSION['captcha'], $request['captcha']) == false) {
			return array('captcha');
		}
		else return true;
	// Disabled
	default:
		return true;
	}
}

// Route reload PHP Captcha
function ejabat_route_captcha_reload() {
	if(get_option('ejabat_captcha_type', 'disabled') == 'php') {
		register_rest_route('ejabberd-account-tools/v1', '/captcha', array(
			'methods' => 'POST',
			'callback' => 'ejabat_captcha_reload',
			'permission_callback' => '__return_true'
		));
	}
}
add_action('rest_api_init', 'ejabat_route_captcha_reload');

// Reload PHP Captcha
function ejabat_captcha_reload() {
	session_start();
	$phrase = new Gregwar\Captcha\PhraseBuilder(get_option('ejabat_phpcaptcha_length', 5));
	$captcha = new Gregwar\Captcha\CaptchaBuilder(null, $phrase);
	$captcha->build(get_option('ejabat_phpcaptcha_width', 150), get_option('ejabat_phpcaptcha_height', 40));
	$_SESSION['captcha'] = $captcha->getPhrase();
	$src = $captcha->inline(get_option('ejabat_phpcaptcha_quality', 100));
	// Return response
	return rest_ensure_response(array('src' => $src));
}
