<?php
/**
 * Captcha settings
 */

if(!defined('ABSPATH')) {
	exit;
}

// Register settings
function ejabat_register_captcha_settings() {
	register_setting('ejabat_captcha', 'ejabat_captcha_type', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_version', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_site_key', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_secret_key', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_theme', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_v2_size', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_v2_badge', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_recaptcha_v3_threshold', array('type' => 'integer', 'sanitize_callback' => 'floatval'));
	register_setting('ejabat_captcha', 'ejabat_phpcaptcha_length', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_captcha', 'ejabat_phpcaptcha_width', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_captcha', 'ejabat_phpcaptcha_height', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_captcha', 'ejabat_phpcaptcha_quality', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_captcha', 'ejabat_phpcaptcha_position', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_captcha', 'ejabat_captcha_loggedin_hide', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
}
add_action('admin_init', 'ejabat_register_captcha_settings');

// Create tools menu
function ejabat_add_admin_captcha() {
	// Add tools page
	if($page_hook = add_submenu_page('ejabat-settings', 'Ejabberd Account Tools - Captcha', 'Captcha', 'manage_options', 'ejabat-captcha', 'ejabat_captcha_page')) {
		// Add CSS style
		add_action('admin_head-'.$page_hook, 'ejabat_admin_css');
		// Add JS script
		add_action('admin_footer-'.$page_hook, 'ejabat_admin_captcha_js');
	}
}
add_action('admin_menu', 'ejabat_add_admin_captcha');

// jQuery script
function ejabat_admin_captcha_js() { ?>
	<script type="text/javascript">
		document.addEventListener('DOMContentLoaded', function() {
			document.querySelector('#ejabat_captcha_type').addEventListener('change', function() {
				document.querySelectorAll('.ejabat_captcha_type').forEach(function(item) {
					item.style.display = 'none';
				});
				document.querySelectorAll('.' + document.querySelector('#ejabat_captcha_type').value).forEach(function(item) {
					item.removeAttribute('style');
				});
			});
			document.querySelector('#ejabat_recaptcha_version').addEventListener('change', function() {
				document.querySelectorAll('.ejabat_recaptcha_version').forEach(function(item) {
					item.style.display = 'none';
				});
				document.querySelectorAll('.' + document.querySelector('#ejabat_recaptcha_version').value).forEach(function(item) {
					item.removeAttribute('style');
				});
			});
		});
	</script>
<?php }

// Display tools page
function ejabat_captcha_page() { ?>
	<div class="wrap">
		<h1 class="wp-heading-inline">Ejabberd Account Tools - Captcha</h1>
		<?php settings_errors(); ?>
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="postbox-container-2" class="postbox-container meta-box-sortables">
					<div id="normal-sortables" class="meta-box-sortables">
						<form id="ejabat-form" method="post" action="options.php">
							<?php settings_fields('ejabat_captcha'); ?>
							<div class="postbox">
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Captcha type', 'ejabberd-account-tools'); ?></th>
											<td>
												<?php $ejabat_captcha_type = get_option('ejabat_captcha_type', 'disabled'); ?>
												<select id="ejabat_captcha_type" name="ejabat_captcha_type">
													<option value="disabled" <?php selected($ejabat_captcha_type, 'disabled'); ?>><?php _e('Disabled', 'ejabberd-account-tools'); ?></option>
													<option value="recaptcha" <?php selected($ejabat_captcha_type, 'recaptcha'); ?>><?php _e('Google reCAPTCHA', 'ejabberd-account-tools'); ?></option>
													<option value="php" <?php selected($ejabat_captcha_type, 'php'); ?>><?php _e('PHP Captcha', 'ejabberd-account-tools'); ?></option>
												</select>
												<p class="description"><?php _e('Choose the captcha type depending on your privacy preferences.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
									</tbody></table>
									<div class="ejabat_captcha_type recaptcha" <?php if(!in_array($ejabat_captcha_type, array('recaptcha'))) { echo 'style="display:none;"'; } ?>>
										<p><?php printf(__('Get reCAPTCHA keys from %s. Make sure to set keys exactly for the selected captcha version.', 'ejabberd-account-tools'), '<a href="https://www.google.com/recaptcha/admin" target="_blank">Google</a>'); ?></p>
										<table class="form-table"><tbody>
											<tr>
												<th><?php _e('Version', 'ejabberd-account-tools'); ?></th>
												<td>
													<?php $ejabat_recaptcha_version = get_option('ejabat_recaptcha_version'); ?>
													<select id="ejabat_recaptcha_version" name="ejabat_recaptcha_version">
														<option value="" <?php selected($ejabat_recaptcha_version, ''); ?>><?php _e('Disabled', 'ejabberd-account-tools'); ?></option>
														<option value="v2_checkbox" <?php selected($ejabat_recaptcha_version, 'v2_checkbox'); ?>>v2 (<?php _e('Checkbox', 'ejabberd-account-tools'); ?>)</option>
														<option value="v2_invisible" <?php selected($ejabat_recaptcha_version, 'v2_invisible'); ?>>v2 (<?php _e('Invisible', 'ejabberd-account-tools'); ?>)</option>
														<option value="v3" <?php selected($ejabat_recaptcha_version, 'v3'); ?>>v3</option>
													</select>
												</td>
											</tr>
											<tr>
												<th><?php _e('Site key', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_recaptcha_site_key" id="ejabat_recaptcha_site_key" type="text" size="48" value="<?php echo get_option('ejabat_recaptcha_site_key'); ?>" />
												</td>
											</tr>
											<tr>
												<th><?php _e('Secret key', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_recaptcha_secret_key" id="ejabat_recaptcha_secret_key" type="text" size="48" value="<?php echo get_option('ejabat_recaptcha_secret_key'); ?>" />
												</td>
											</tr>
											<tr class="ejabat_recaptcha_version v2_checkbox" <?php if(!in_array($ejabat_recaptcha_version, array('v2_checkbox'))) { echo 'style="display:none;"'; } ?>>
												<th><?php _e('Size', 'ejabberd-account-tools'); ?></th>
												<td>
													<?php $ejabat_recaptcha_v2_size = get_option('ejabat_recaptcha_v2_size', 'normal'); ?>
													<select id="ejabat_recaptcha_v2_size" name="ejabat_recaptcha_v2_size">
														<option value="normal" <?php selected($ejabat_recaptcha_v2_size, 'normal'); ?>><?php _e('Normal', 'ejabberd-account-tools'); ?></option>
														<option value="compact" <?php selected($ejabat_recaptcha_v2_size, 'compact'); ?>><?php _e('Compact', 'ejabberd-account-tools'); ?></option>
													</select>
												</td>
											</tr>
											<tr class="ejabat_recaptcha_version v2_invisible" <?php if(!in_array($ejabat_recaptcha_version, array('v2_invisible'))) { echo 'style="display:none;"'; } ?>>
												<th><?php _e('Badge', 'ejabberd-account-tools'); ?></th>
												<td>
													<?php $ejabat_recaptcha_v2_badge = get_option('ejabat_recaptcha_v2_badge', 'bottomright'); ?>
													<select id="ejabat_recaptcha_v2_badge" name="ejabat_recaptcha_v2_badge">
														<option value="normal" <?php selected($ejabat_recaptcha_v2_badge, 'bottomright'); ?>><?php _e('Bottom right', 'ejabberd-account-tools'); ?></option>
														<option value="bottomleft" <?php selected($ejabat_recaptcha_v2_badge, 'bottomleft'); ?>><?php _e('Bottom left', 'ejabberd-account-tools'); ?></option>
														<option value="inline" <?php selected($ejabat_recaptcha_v2_badge, 'inline'); ?>><?php _e('Inline', 'ejabberd-account-tools'); ?></option>
													</select>
												</td>
											</tr>
											<tr class="ejabat_recaptcha_version v3" <?php if(!in_array($ejabat_recaptcha_version, array('v3'))) { echo 'style="display:none;"'; } ?>>
												<th><?php _e('Score threshold', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_recaptcha_v3_threshold" id="ejabat_recaptcha_v3_threshold" type="number" min="0.0" max="1.0" step="0.1" value="<?php echo get_option('ejabat_recaptcha_v3_threshold', 0.5); ?>" />
													<p class="description"><?php _e('Minimum threshold to pass validation (1.0 is very likely a good interaction, 0.0 is very likely a bot).', 'ejabberd-account-tools'); ?></p>
												</td>
											</tr>
											<tr class="ejabat_recaptcha_version v2_checkbox v2_invisible" <?php if(!in_array($ejabat_recaptcha_version, array('v2_checkbox', 'v2_invisible'))) { echo 'style="display:none;"'; } ?>>
												<th><?php _e('Theme', 'ejabberd-account-tools'); ?></th>
												<td>
													<?php $ejabat_recaptcha_theme = get_option('ejabat_recaptcha_theme', 'auto'); ?>
													<select id="ejabat_recaptcha_theme" name="ejabat_recaptcha_theme">
														<option value="auto" <?php selected($ejabat_recaptcha_theme, 'auto'); ?>><?php _e('Auto detect', 'ejabberd-account-tools'); ?></option>
														<option value="light" <?php selected($ejabat_recaptcha_theme, 'light'); ?>><?php _e('Light', 'ejabberd-account-tools'); ?></option>
														<option value="dark" <?php selected($ejabat_recaptcha_theme, 'dark'); ?>><?php _e('Dark', 'ejabberd-account-tools'); ?></option>
													</select>
												</td>
											</tr>
										</tbody></table>
									</div>
									<div class="ejabat_captcha_type php" <?php if(!in_array($ejabat_captcha_type, array('php'))) { echo 'style="display:none;"'; } ?>>
										<table class="form-table"><tbody>
											<tr>
												<th><?php _e('Phrase length', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_phpcaptcha_length" id="ejabat_phpcaptcha_length" type="number" min="4" max="10" value="<?php echo get_option('ejabat_phpcaptcha_length', 5); ?>" />&nbsp;<?php _e('characters', 'ejabberd-account-tools'); ?>
												</td>
											</tr>
											<tr>
												<th><?php _e('Image quality', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_phpcaptcha_quality" id="ejabat_phpcaptcha_quality" type="number" min="1" max="100" value="<?php echo get_option('ejabat_phpcaptcha_quality', 100); ?>" />
												</td>
											</tr>
											<tr>
												<th><?php _e('Width', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_phpcaptcha_width" id="ejabat_phpcaptcha_width" type="number" min="1" max="999" value="<?php echo get_option('ejabat_phpcaptcha_width', 150); ?>" />&nbsp;px
												</td>
											</tr>
											<tr>
												<th><?php _e('Height', 'ejabberd-account-tools'); ?></th>
												<td>
													<input name="ejabat_phpcaptcha_height" id="ejabat_phpcaptcha_height" type="number" min="1" max="999" value="<?php echo get_option('ejabat_phpcaptcha_height', 40); ?>" />&nbsp;px
												</td>
											</tr>
											<tr>
												<th><?php _e('Position', 'ejabberd-account-tools'); ?></th>
												<td>
													<?php $ejabat_phpcaptcha_position = get_option('ejabat_phpcaptcha_position', 'right'); ?>
													<select id="ejabat_phpcaptcha_position" name="ejabat_phpcaptcha_position">
														<option value="left" <?php selected($ejabat_phpcaptcha_position, 'left'); ?>><?php _e('On the left', 'ejabberd-account-tools'); ?></option>
														<option value="right" <?php selected($ejabat_phpcaptcha_position, 'right'); ?>><?php _e('On the right', 'ejabberd-account-tools'); ?></option>
													</select>
												</td>
											</tr>
										</tbody></table>
									</div>
									<div class="ejabat_captcha_type recaptcha php" <?php if(!in_array($ejabat_captcha_type, array('recaptcha', 'php'))) { echo 'style="display:none;"'; } ?>>
										<table class="form-table" style="margin-top:0;"><tbody>
											<tr>
												<th><?php _e('Visibility', 'ejabberd-account-tools'); ?></th>
												<td>
													<label for="ejabat_captcha_loggedin_hide"><input name="ejabat_captcha_loggedin_hide" id="ejabat_captcha_loggedin_hide" type="checkbox" value="1" <?php checked(1, get_option('ejabat_captcha_loggedin_hide', true)); ?> /><?php _e('Hide captcha for logged in users', 'ejabberd-account-tools'); ?></label>
												</td>
											</tr>
										</tbody></table>
									</div>
								</div>
							</div>
							<?php submit_button(__('Save settings', 'ejabberd-account-tools'), 'primary', 'submit', false); ?>
						</form>
					</div>
				</div>
				<div id="postbox-container-1" class="postbox-container">
					<div id="side-sortables" class="meta-box-sortables">
						<div class="postbox">
							<div class="inside">
								<p><?php _e('If you like this plugin please give a review at WordPress.org.', 'ejabberd-account-tools'); ?></p>
								<p class="rating-stars"><a href="https://wordpress.org/support/plugin/ejabberd-account-tools/reviews/?rate=5#new-post" target="_blank"><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span></a></p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php }
