<?php
/**
 * Admin tools
 */

if(!defined('ABSPATH')) {
	exit;
}

// Create tools menu
function ejabat_add_admin_tools() {
	// Add tools page
	if($page_hook = add_submenu_page('ejabat-settings', 'Ejabberd Account Tools - '.__('Tools', 'ejabberd-account-tools'), __('Tools', 'ejabberd-account-tools'), 'manage_options', 'ejabat-tools', 'ejabat_tools_page')) {
		// Add CSS style
		add_action('admin_head-'.$page_hook, 'ejabat_admin_css');
	}
}
add_action('admin_menu', 'ejabat_add_admin_tools');

// Display tools page
function ejabat_tools_page() { ?>
	<div class="wrap">
		<h1 class="wp-heading-inline">Ejabberd Account Tools - <?php _e('Tools', 'ejabberd-account-tools'); ?></h1>
		<?php // Verify POST and nonce
		if((isset($_POST['change_email']) || isset($_POST['check_email']) || isset($_POST['ban_account']) || isset($_POST['unban_account']) || isset($_POST['get_ban_details']) || isset($_POST['unban_ip']) || isset($_POST['send_message'])) && wp_verify_nonce($_POST['_ejabat_nonce'], 'ejabat_tools_nonce')) {
			if(isset($_POST['change_email'])) {
				// Change email
				$callback = ejabat_change_email_admin_callback();
			}
			else if(isset($_POST['check_email'])) {
				// Change email
				$callback = ejabat_check_email_admin_callback();
			}
			else if(isset($_POST['ban_account'])) {
				// Ban account
				$callback = ejabat_ban_account_admin_callback();
			}
			else if(isset($_POST['unban_account'])) {
				// Unban account
				$callback = ejabat_unban_account_admin_callback();
			}
			else if(isset($_POST['get_ban_details'])) {
				// Get ban details
				$callback = ejabat_get_ban_details_admin_callback();
			}
			else if(isset($_POST['unban_ip'])) {
				// Change email
				$callback = ejabat_unban_ip_admin_callback();
			}
			else if(isset($_POST['send_message'])) {
				// Change email
				$callback = ejabat_send_message_admin_callback();
			}
			// Show message
			echo '<div class="notice notice-'.$callback['status'].' is-dismissible"><p><strong>'.$callback['message'].'</strong></p></div>';
		}
		// Generate new nonce
		$nonce = wp_nonce_field('ejabat_tools_nonce', '_ejabat_nonce', false, false); ?>
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="postbox-container-2" class="postbox-container meta-box-sortables">
					<div id="normal-sortables" class="meta-box-sortables">
						<form id="ejabat_change_email" method="post">
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Private email address', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<p><?php _e('Here you can change or delete the private email address for a specified XMPP account.', 'ejabberd-account-tools'); ?></p>
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('JID', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="jid" id="jid" type="text" size="40" value="<?php echo isset($_POST['jid']) ? stripslashes_deep($_POST['jid']) : ''; ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Email', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="email" id="email" type="text" size="40" value="<?php echo isset($_POST['email']) ? stripslashes_deep($_POST['email']) : ''; ?>" />
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<?php echo $nonce; ?>
									<input name="change_email" id="change_email" type="submit" class="button button-primary" value="<?php _e('Change email', 'ejabberd-account-tools'); ?>" />
									<input name="check_email" id="check_email" type="submit" class="button button-secondary" value="<?php _e('Check email', 'ejabberd-account-tools'); ?>" />
								</div>
							</div>
						</form>
						<form id="ejabat_ban_account" method="post">
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Ban account', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<p><?php _e('Ban terminates all active user sessions, sets a random password, and prevents the user from resetting it by deleting the private email address.', 'ejabberd-account-tools'); ?></p>
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('JID', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="jid" id="jid" type="text" size="40" value="<?php echo isset($_POST['jid']) ? stripslashes_deep($_POST['jid']) : ''; ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Reason', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="reason" id="reason" type="text" size="40" value="<?php echo isset($_POST['reason']) ? stripslashes_deep($_POST['reason']) : ''; ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Ban date', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="bandate" id="bandate" type="text" size="40" value="<?php echo isset($_POST['bandate']) ? stripslashes_deep($_POST['bandate']) : ''; ?>" disabled/>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<?php echo $nonce; ?>
									<input name="ban_account" id="ban_account" type="submit" class="button button-primary" value="<?php _e('Ban account', 'ejabberd-account-tools'); ?>" />
									<input name="unban_account" id="unban_account" type="submit" class="button button-secondary" value="<?php _e('Unban account', 'ejabberd-account-tools'); ?>" />
									<input name="get_ban_details" id="get_ban_details" type="submit" class="button button-secondary" value="<?php _e('Get ban details', 'ejabberd-account-tools'); ?>" />
								</div>
							</div>
						</form>
						<form id="ejabat_unban_ip" method="post">
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Unban IP address', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<p><?php _e('Here you can remove banned IP addresses from the fail2ban table.', 'ejabberd-account-tools'); ?></p>
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('IP', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ip" id="ip" type="text" size="40" value="<?php echo isset($_POST['ip']) ? stripslashes_deep($_POST['ip']) : ''; ?>" />
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<?php echo $nonce; ?>
									<input name="unban_ip" id="unban_ip" type="submit" class="button button-primary" value="<?php _e('Unban IP', 'ejabberd-account-tools'); ?>" />
								</div>
							</div>
						</form>
						<form id="ejabat_send_message" method="post">
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Send message', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('JID', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="jid" id="jid" type="text" size="40" value="<?php echo isset($_POST['jid']) ? stripslashes_deep($_POST['jid']) : ''; ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Subject', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="subject" id="subject" type="text" size="40" value="<?php echo isset($_POST['subject']) ? stripslashes_deep($_POST['subject']) : ''; ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Content', 'ejabberd-account-tools'); ?></th>
											<td>
												<textarea name="content" id="content" type="text" cols="50" rows="5" /><?php echo isset($_POST['content']) ? stripslashes_deep($_POST['content']) : ''; ?></textarea>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<?php echo $nonce; ?>
									<input id="send_message" name="send_message" type="submit" class="button button-primary" value="<?php _e('Send message', 'ejabberd-account-tools'); ?>" />
								</div>
							</div>
						</form>
					</div>
				</div>
				<div id="postbox-container-1" class="postbox-container">
					<div id="side-sortables" class="meta-box-sortables">
						<div class="postbox">
							<div class="inside">
								<p><?php _e('If you like this plugin please give a review at WordPress.org.', 'ejabberd-account-tools'); ?></p>
								<p class="rating-stars"><a href="https://wordpress.org/support/plugin/ejabberd-account-tools/reviews/?rate=5#new-post" target="_blank"><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span></a></p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php }

// Change email - admin form callback
function ejabat_change_email_admin_callback() {
	// Verify JID
	if($_POST['jid']) {
		// Get login and host name
		list($login, $host) = array_pad(explode('@', stripslashes_deep(sanitize_text_field($_POST['jid'])), 2), 2, get_option('ejabat_hostname', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])));
		// Check account
		$response = ejabat_get_xmpp_data('check_account', array('user' => $login, 'host' => $host));
		// Server unavailable
		if(is_null($response)) {
			$status = 'error';
			$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
		}
		// User not found
		else if($response['code'] == 1) {
			$status = 'warning';
			$message = __('Invalid JID, please correct it and try again.', 'ejabberd-account-tools');
		}
		// User found
		else if($response['code'] == 0) {
			// Verify email
			$email = stripslashes_deep(sanitize_text_field($_POST['email']));
			if((!empty($email)) && (!filter_var($email, FILTER_VALIDATE_EMAIL) || !ejabat_validate_email_mxrecord($email))) {
				$status = 'warning';
				$message = __('The email address is invalid. Please change it and try again.', 'ejabberd-account-tools');
			}
			else if((!empty($email)) && !ejabat_validate_email_usercheck_com($email)) {
				$status = 'warning';
				$message = __('Disposable email addresses are not allowed. Please change the entered email address and try again.', 'ejabberd-account-tools');
			}
			else {
				// Get current private email address
				$response = ejabat_get_xmpp_data('private_get', array('user' => $login, 'host' => $host, 'element' => 'private', 'ns' => 'email'));
				// Server unavailable
				if(is_null($response)) {
					$status = 'error';
					$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
				}
				// Check response
				else if($response['code'] == 0) {
					// New email address different from current
					if(empty($email) || ($email != json_decode(strip_tags($response['body'])))) {
						// Delete private email
						if(empty($email)) {
							$response = ejabat_get_xmpp_data('private_set', array('user' => $login, 'host' => $host, 'element' => '<private xmlns=\'email\'/>'));
							// Server unavailable
							if(is_null($response)) {
								$status = 'error';
								$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
							}
							// Private email changed
							else if($response['code'] == 0) {
								$status = 'success';
								$message = sprintf(__('The private email address for XMPP account %s has been successfully deleted.', 'ejabberd-account-tools'), $login.'@'.$host, $email);
							}
						}
						// Set private email
						else {
							$response = ejabat_get_xmpp_data('private_set', array('user' => $login, 'host' => $host, 'element' => '<private xmlns=\'email\'>'.$email.'</private>'));
							// Server unavailable
							if(is_null($response)) {
								$status = 'error';
								$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
							}
							// Private email changed
							else if($response['code'] == 0) {
								$status = 'success';
								$message = sprintf(__('The private email address for XMPP account %s has been successfully changed to %s.', 'ejabberd-account-tools'), $login.'@'.$host, $email);
							}
						}
					}
					// New private email address same as current
					else {
						$status = 'warning';
						$message = __('The selected private email address is already set up for this account.', 'ejabberd-account-tools');
					}
				}
			}
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter a JID and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}

// Check email - admin form callback
function ejabat_check_email_admin_callback() {
	// Verify JID
	if($_POST['jid']) {
		// Get login and host name
		list($login, $host) = array_pad(explode('@', stripslashes_deep(sanitize_text_field($_POST['jid'])), 2), 2, get_option('ejabat_hostname', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])));
		// Check account
		$response = ejabat_get_xmpp_data('check_account', array('user' => $login, 'host' => $host));
		// Server unavailable
		if(is_null($response)) {
			$status = 'error';
			$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
		}
		// User not found
		else if($response['code'] == 1) {
			$status = 'warning';
			$message = __('Invalid JID, please correct it and try again.', 'ejabberd-account-tools');
		}
		// User found
		else if($response['code'] == 0) {
			// Get current private email address
			$response = ejabat_get_xmpp_data('private_get', array('user' => $login, 'host' => $host, 'element' => 'private', 'ns' => 'email'));
			// Server unavailable
			if(is_null($response)) {
				$status = 'error';
				$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
			}
			// Check response
			else if($response['code'] == 0) {
				// Private email set
				if(true == ($email = json_decode(strip_tags($response['body'])))) {
					// Fetch email address
					$_POST['email'] = $email;
					$status = 'success';
					$message = __('Private email address has been successfully obtained.', 'ejabberd-account-tools');
				}
				// Private email not set
				else {
					$message = __('A private email address hasn\'t been set for this account.', 'ejabberd-account-tools');
					$status = 'error';
				}
			}
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter a JID and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}

// Ban account - admin form callback
function ejabat_ban_account_admin_callback() {
	// Verify JID
	if($_POST['jid']) {
		// Get login and host name
		list($login, $host) = array_pad(explode('@', stripslashes_deep(sanitize_text_field($_POST['jid'])), 2), 2, get_option('ejabat_hostname', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])));
		// Check account
		$response = ejabat_get_xmpp_data('check_account', array('user' => $login, 'host' => $host));
		// Server unavailable
		if(is_null($response)) {
			$status = 'error';
			$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
		}
		// User not found
		else if($response['code'] == 1) {
			$status = 'warning';
			$message = __('Invalid JID, please correct it and try again.', 'ejabberd-account-tools');
		}
		// User found
		else if($response['code'] == 0) {
			// Ban account
			$response = ejabat_get_xmpp_data('ban_account', array('user' => $login, 'host' => $host, 'reason' => $_POST['reason']));
			// Server unavailable
			if(is_null($response)) {
				$status = 'error';
				$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
			}
			// Account banned
			else if($response['code'] == 0) {
				$status = 'success';
				$message = __('The account has been successfully banned.', 'ejabberd-account-tools');
			}
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter a JID and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}

// Unban account - admin form callback
function ejabat_unban_account_admin_callback() {
	// Verify JID
	if($_POST['jid']) {
		// Get login and host name
		list($login, $host) = array_pad(explode('@', stripslashes_deep(sanitize_text_field($_POST['jid'])), 2), 2, get_option('ejabat_hostname', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])));
		// Check account
		$response = ejabat_get_xmpp_data('check_account', array('user' => $login, 'host' => $host));
		// Server unavailable
		if(is_null($response)) {
			$status = 'error';
			$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
		}
		// User not found
		else if($response['code'] == 1) {
			$status = 'warning';
			$message = __('Invalid JID, please correct it and try again.', 'ejabberd-account-tools');
		}
		// User found
		else if($response['code'] == 0) {
			// Unban account
			$response = ejabat_get_xmpp_data('unban_account', array('user' => $login, 'host' => $host));
			// Server unavailable
			if(is_null($response)) {
				$status = 'error';
				$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
			}
			// Account unbanned
			else if($response['code'] == 0) {
				$status = 'success';
				$message = __('The account has been successfully unbanned.', 'ejabberd-account-tools');
			}
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter a JID and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}

// Get ban details - admin form callback
function ejabat_get_ban_details_admin_callback() {
	// Verify JID
	if($_POST['jid']) {
		// Get login and host name
		list($login, $host) = array_pad(explode('@', stripslashes_deep(sanitize_text_field($_POST['jid'])), 2), 2, get_option('ejabat_hostname', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])));
		// Check account
		$response = ejabat_get_xmpp_data('check_account', array('user' => $login, 'host' => $host));
		// Server unavailable
		if(is_null($response)) {
			$status = 'error';
			$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
		}
		// User not found
		else if($response['code'] == 1) {
			$status = 'warning';
			$message = __('Invalid JID, please correct it and try again.', 'ejabberd-account-tools');
		}
		// User found
		else if($response['code'] == 0) {
			// Get ban details
			$response = ejabat_get_xmpp_data('get_ban_details', array('user' => $login, 'host' => $host));
			// Server unavailable
			if(is_null($response)) {
				$status = 'error';
				$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
			}
			// Ban details
			else if($response['code'] == 0) {
				$_POST['reason'] = isset(json_decode($response['body'])->reason) ? json_decode($response['body'])->reason : '';
				$_POST['bandate'] = isset(json_decode($response['body'])->bandate) ? json_decode($response['body'])->bandate : '';
				$status = 'success';
				$message = __('Ban details successfully obtained.', 'ejabberd-account-tools');
			}
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter a JID and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}

// Unban IP - admin form callback
function ejabat_unban_ip_admin_callback() {
	// Verify IP
	if($_POST['ip']) {
		// Validate IP
		if(filter_var($_POST['ip'], FILTER_VALIDATE_IP)) {
			// Unban IP
			$response = ejabat_get_xmpp_data('unban_ip', array('address' => $_POST['ip']));
			// Server unavailable
			if(is_null($response)) {
				$status = 'error';
				$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
			}
			// Check response
			// IP unbaned
			else if($response['code'] == 0) {
				$status = 'success';
				$message = __('IP address successfully removed from the fail2ban table.', 'ejabberd-account-tools');
			}
		}
		// Invalid IP
		else {
			$status = 'warning';
			$message = __('Invalid IP address. Please check it again.', 'ejabberd-account-tools');
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter the IP address and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}

// Send message - admin form callback
function ejabat_send_message_admin_callback() {
	// Verify JID
	if($_POST['jid']) {
		// Get login and host name
		list($login, $host) = array_pad(explode('@', stripslashes_deep(sanitize_text_field($_POST['jid'])), 2), 2, get_option('ejabat_hostname', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])));
		// Check account
		$response = ejabat_get_xmpp_data('check_account', array('user' => $login, 'host' => $host));
		// Server unavailable
		if(is_null($response)) {
			$status = 'error';
			$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
		}
		// User not found
		else if($response['code'] == 1) {
			$status = 'warning';
			$message = __('Invalid JID, please correct it and try again.', 'ejabberd-account-tools');
		}
		// User found
		else if($response['code'] == 0) {
			// Verify content
			if($_POST['content']) {
				// Get subject and content
				$subject = htmlspecialchars(wp_strip_all_tags(do_shortcode(stripslashes_deep(sanitize_text_field($_POST['subject'])))));
				$content = htmlspecialchars(wp_strip_all_tags(do_shortcode(stripslashes_deep(sanitize_text_field($_POST['content'])))));
				// Send message
				if($subject) {
					$response = ejabat_get_xmpp_data('send_message', array('type' => 'normal', 'from' => $host, 'to' => $login.'@'.$host, 'subject' => $subject, 'body' => $content));
				} else {
					$response = ejabat_get_xmpp_data('send_message', array('type' => 'chat', 'from' => $host, 'to' => $login.'@'.$host, 'subject' => '', 'body' => $content));
				}
				// Server unavailable
				if(is_null($response)) {
					$status = 'error';
					$message = __('The server is temporarily unavailable. Please try again later.', 'ejabberd-account-tools');
				}
				// Message sent
				else if($response['code'] == 0) {
					$status = 'success';
					$message = __('The message was sent successfully.', 'ejabberd-account-tools');
				}
			}
			else {
				$status = 'warning';
				$message = __('Please enter a message content and try again.', 'ejabberd-account-tools');
			}
		}
	}
	else {
		$status = 'warning';
		$message = __('Please enter a JID and check again.', 'ejabberd-account-tools');
	}
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}
