<?php
/**
 * Cleaning the database from expired transients
 */

if(!defined('ABSPATH')) {
	exit;
}

// Activation hook
function ejabat_activated() {
	// Add cron job
	wp_schedule_event(time(), 'daily', 'ejabat_cron');
}
register_activation_hook(EJABAT_DIR.'ejabat.php', 'ejabat_activated');

// Deactivation hook
function ejabat_deactivated() {
	// Remove cron job
	wp_clear_scheduled_hook('ejabat_cron');
}
register_deactivation_hook(EJABAT_DIR.'ejabat.php', 'ejabat_deactivated');

// Removing expired transients
function ejabat_cron() {
	$time = time();
	global $wpdb;
	$expired = $wpdb->get_col("SELECT option_name FROM $wpdb->options WHERE option_name LIKE '_transient_timeout_ejabat_%' AND option_value < $time");
	foreach($expired as $transient) {
		delete_transient(str_replace('_transient_timeout_', '', $transient));
	}
}
add_action('ejabat_cron', 'ejabat_cron');
