<?php
/**
 * Add reCAPTCHA to comments
 */

if(!defined('ABSPATH')) {
	exit;
}

// Add grecaptcha tag
function grecaptcha_comments_field() {
	echo grecaptcha_field();
}
add_action('comment_form_after_fields', 'grecaptcha_comments_field', 99);

// Change submit button
function grecaptcha_comments_form_submit_button($submit_button, $args) {
	if(!is_user_logged_in()) {
		return '<input type="submit" class="submit" value="'.$args['label_submit'].'" />';
	}
	return $submit_button;
};
add_filter('comment_form_submit_button', 'grecaptcha_comments_form_submit_button', 10, 2);

// Enqueue reCAPTCHA inline scripts
function grecaptcha_comments_enqueue_inline_scripts() {
	if(comments_open()) {
		grecaptcha_enqueue_inline_scripts('#commentform');
	}
}
add_action('wp_print_footer_scripts', 'grecaptcha_comments_enqueue_inline_scripts');

// Validate reCAPTCHA
function grecaptcha_comments_verify($approved, $commentdata) {
	// Get reCAPTCHA response
	$token = $_POST['g-recaptcha-response'];
	// Validate token
	if(!grecaptcha_verify($token)) {
		return new WP_Error('invalid_recaptcha', '<strong>'.__('ERROR', 'grecaptcha').'</strong>: '.__('reCAPTCHA validation error, try again.', 'grecaptcha'), 403);
	}
	return $approved;
}
add_filter('pre_comment_approved', 'grecaptcha_comments_verify', 10, 2);
