<?php
/**
 * Settings
 */

if(!defined('ABSPATH')) {
	exit;
}

// Register settings
function grecaptcha_register_settings() {
	register_setting('grecaptcha', 'grecaptcha_version', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('grecaptcha', 'grecaptcha_site_key', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('grecaptcha', 'grecaptcha_secret_key', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('grecaptcha', 'grecaptcha_theme', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('grecaptcha', 'grecaptcha_v2_size', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('grecaptcha', 'grecaptcha_v2_badge', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('grecaptcha', 'grecaptcha_v3_threshold', array('type' => 'integer', 'sanitize_callback' => 'floatval'));
}
add_action('admin_init', 'grecaptcha_register_settings');

// Add link to the settings on plugins page
function grecaptcha_plugin_action_links($links) {
	$links[] = '<a href="'.esc_url(admin_url('options-general.php?page=grecaptcha')).'">'.__('Settings', 'grecaptcha').'</a>';
	return $links;
}
add_filter('plugin_action_links_'.GRECAPTCHA_BASENAME, 'grecaptcha_plugin_action_links');

// Create tools menu
function grecaptcha_add_settings() {
	// Add options page
	if($page_hook = add_options_page('GreCAPTCHA', 'GreCAPTCHA', 'manage_options', 'grecaptcha', 'grecaptcha_settings_page')) {
		// Add CSS style
		add_action('admin_head-'.$page_hook, 'grecaptcha_settings_css');
		// Add JS script
		add_action('admin_footer-'.$page_hook, 'grecaptcha_settings_js');
	}
}
add_action('admin_menu', 'grecaptcha_add_settings');

// CSS style
function grecaptcha_settings_css() { ?>
	<style>
		.metabox-holder .postbox .hndle{
		cursor:default;
		}
		.postbox.opened .hndle, .postbox.closed .hndle{
		cursor:pointer;
		}
		.rating-stars{
		text-align:center;
		}
		.rating-stars a{
		color:#ffb900;
		text-decoration:none;
		}
	</style>
<?php }

// JS script
function grecaptcha_settings_js() { ?>
	<script type="text/javascript">
		document.addEventListener('DOMContentLoaded', function() {
			document.querySelector('#grecaptcha_version').addEventListener('change', function() {
				document.querySelectorAll('.grecaptcha_version').forEach(function(item) {
					item.style.display = 'none';
				});
				document.querySelectorAll('.' + document.querySelector('#grecaptcha_version').value).forEach(function(item) {
					item.removeAttribute('style');
				});
			});
		});
	</script>
<?php }

// Display settins page
function grecaptcha_settings_page() { ?>
	<div class="wrap">
		<h1 class="wp-heading-inline">GreCAPTCHA</h1>
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="postbox-container-2" class="postbox-container">
					<div id="normal-sortables" class="meta-box-sortables">
						<form id="grecaptcha-form" method="post" action="options.php">
							<?php settings_fields('grecaptcha'); ?>
							<div class="postbox">
								<div class="inside">
									<p><?php printf(__('Get reCAPTCHA keys from %s. Make sure to set keys exactly for the selected captcha version.', 'grecaptcha'), '<a href="https://www.google.com/recaptcha/admin" target="_blank">Google</a>'); ?></p>
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Version', 'grecaptcha'); ?></th>
											<td>
												<?php $grecaptcha_version = get_option('grecaptcha_version'); ?>
												<select id="grecaptcha_version" name="grecaptcha_version">
													<option <?php selected($grecaptcha_version, ''); ?> disabled hidden><?php _e('Disabled', 'grecaptcha'); ?></option>
													<option value="v2_checkbox" <?php selected($grecaptcha_version, 'v2_checkbox'); ?>>v2 (<?php _e('Checkbox', 'grecaptcha'); ?>)</option>
													<option value="v2_invisible" <?php selected($grecaptcha_version, 'v2_invisible'); ?>>v2 (<?php _e('Invisible', 'grecaptcha'); ?>)</option>
													<option value="v3" <?php selected($grecaptcha_version, 'v3'); ?>>v3</option>
												</select>
											</td>
										</tr>
										<tr>
											<th><?php _e('Site key', 'grecaptcha'); ?></th>
											<td>
												<input name="grecaptcha_site_key" id="grecaptcha_site_key" type="text" size="48" value="<?php echo get_option('grecaptcha_site_key'); ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Secret key', 'grecaptcha'); ?></th>
											<td>
												<input name="grecaptcha_secret_key" id="grecaptcha_secret_key" type="text" size="48" value="<?php echo get_option('grecaptcha_secret_key'); ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Language', 'grecaptcha'); ?></th>
											<td>
												<select disabled>
													<option><?php _e('Auto detect', 'grecaptcha'); ?></option>
												</select>
											</td>
										</tr>
										<tr class="grecaptcha_version v2_checkbox" <?php if(!in_array($grecaptcha_version, array('v2_checkbox'))) { echo 'style="display:none;"'; } ?>>
											<th><?php _e('Size', 'grecaptcha'); ?></th>
											<td>
												<?php $grecaptcha_v2_size = get_option('grecaptcha_v2_size', 'normal'); ?>
												<select id="grecaptcha_v2_size" name="grecaptcha_v2_size">
													<option value="normal" <?php selected($grecaptcha_v2_size, 'normal'); ?>><?php _e('Normal', 'grecaptcha'); ?></option>
													<option value="compact" <?php selected($grecaptcha_v2_size, 'compact'); ?>><?php _e('Compact', 'grecaptcha'); ?></option>
												</select>
											</td>
										</tr>
										<tr class="grecaptcha_version v2_invisible" <?php if(!in_array($grecaptcha_version, array('v2_invisible'))) { echo 'style="display:none;"'; } ?>>
											<th><?php _e('Badge', 'grecaptcha'); ?></th>
											<td>
												<?php $grecaptcha_v2_badge = get_option('grecaptcha_v2_badge', 'bottomright'); ?>
												<select id="grecaptcha_v2_badge" name="grecaptcha_v2_badge">
													<option value="normal" <?php selected($grecaptcha_v2_badge, 'bottomright'); ?>><?php _e('Bottom right', 'grecaptcha'); ?></option>
													<option value="bottomleft" <?php selected($grecaptcha_v2_badge, 'bottomleft'); ?>><?php _e('Bottom left ', 'grecaptcha'); ?></option>
													<option value="inline" <?php selected($grecaptcha_v2_badge, 'inline'); ?>><?php _e('Inline', 'grecaptcha'); ?></option>
												</select>
											</td>
										</tr>
										<tr class="grecaptcha_version v3" <?php if(!in_array($grecaptcha_version, array('v3'))) { echo 'style="display:none;"'; } ?>>
											<th><?php _e('Score threshold', 'grecaptcha'); ?></th>
											<td>
												<input name="grecaptcha_v3_threshold" id="grecaptcha_v3_threshold" type="number" min="0.0" max="1.0" step="0.1" value="<?php echo get_option('grecaptcha_v3_threshold', 0.5); ?>" />
												<p class="description"><?php _e('Minimum threshold to pass validation (1.0 is very likely a good interaction, 0.0 is very likely a bot).', 'grecaptcha'); ?></p>
											</td>
										</tr>
										<tr class="grecaptcha_version v2_checkbox v2_invisible" <?php if(!in_array($grecaptcha_version, array('v2_checkbox', 'v2_invisible'))) { echo 'style="display:none;"'; } ?>>
											<th><?php _e('Theme', 'grecaptcha'); ?></th>
											<td>
												<?php $grecaptcha_theme = get_option('grecaptcha_theme', 'auto'); ?>
												<select id="grecaptcha_theme" name="grecaptcha_theme">
													<option value="auto" <?php selected($grecaptcha_theme, 'auto'); ?>><?php _e('Auto detect', 'grecaptcha'); ?></option>
													<option value="light" <?php selected($grecaptcha_theme, 'light'); ?>><?php _e('Light', 'grecaptcha'); ?></option>
													<option value="dark" <?php selected($grecaptcha_theme, 'dark'); ?>><?php _e('Dark', 'grecaptcha'); ?></option>
												</select>
											</td>
										</tr>
									</tbody></table>
								</div>
							</div>
							<?php submit_button(__('Save settings', 'grecaptcha'), 'primary', 'submit', false); ?>
						</form>
					</div>
				</div>
				<div id="postbox-container-1" class="postbox-container">
					<div id="side-sortables" class="meta-box-sortables">
						<div class="postbox">
							<div class="inside">
								<p><?php _e('If you like this plugin please give a review at WordPress.org.', 'grecaptcha'); ?></p>
								<p class="rating-stars"><a href="https://wordpress.org/support/plugin/grecaptcha/reviews/?rate=5#new-post" target="_blank"><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span></a></p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php }
