<?php
/**
 * Add reCAPTCHA to login area
 */

if(!defined('ABSPATH')) {
	exit;
}

// Enqueue reCAPTCHA scripts
function grecaptcha_enqueue_login_scripts() {
	echo '<style id="grecaptcha-inline-css" type="text/css">.g-recaptcha:not(:empty){margin-bottom:16px!important;}</style>'."\r\n";
}
add_action('login_enqueue_scripts', 'grecaptcha_enqueue_login_scripts');

// Enqueue reCAPTCHA inline scripts
function grecaptcha_enqueue_login_inline_scripts() {
	global $action;
	switch($action) {
		case 'login':
			grecaptcha_enqueue_inline_scripts('#loginform');
			break;
		case 'lostpassword':
		case 'retrievepassword':
			grecaptcha_enqueue_inline_scripts('#lostpasswordform');
			break;
		case 'resetpass':
			grecaptcha_enqueue_inline_scripts('#resetpass');
			break;
		case 'register':
			grecaptcha_enqueue_inline_scripts('#registerform');
			break;
	}
}
add_action('login_footer', 'grecaptcha_enqueue_login_inline_scripts');

// Add reCAPTCHA field
function grecaptcha_login_field() {
	echo grecaptcha_field();
}
add_action('login_form', 'grecaptcha_login_field', 99);
add_action('lostpassword_form', 'grecaptcha_login_field', 99);
add_action('resetpass_form', 'grecaptcha_login_field', 99);
add_action('register_form', 'grecaptcha_login_field', 99);

// Validate reCAPTCHA on login form
function grecaptcha_validate_login_form($user, $username = '', $password = '') {
	if(!$username) {
		return $user;
	}
	// Get reCAPTCHA response
	$token = $_POST['g-recaptcha-response'];
	// Validate token
	if(!grecaptcha_verify($token)) {
		return new WP_Error('invalid_recaptcha', '<strong>'.__('ERROR', 'grecaptcha').'</strong>: '.__('reCAPTCHA validation error, try again.', 'grecaptcha'));
	}
	return $user;
}
add_filter('authenticate', 'grecaptcha_validate_login_form', 25, 3);

// Validate reCAPTCHA on lost and reset password form
function grecaptcha_validate_password_form($errors) {
	// Get reCAPTCHA response
	$token = $_POST['g-recaptcha-response'];
	// Validate token
	if(!grecaptcha_verify($token)) {
		$errors->add('invalid_recaptcha', '<strong>'.__('ERROR', 'grecaptcha').'</strong>: '.__('reCAPTCHA validation error, try again.', 'grecaptcha'));
	}
}
add_action('lostpassword_post', 'grecaptcha_validate_password_form');

// Validate reCAPTCHA on register form
function grecaptcha_validate_register_form($errors, $sanitized_user_login, $user_email) {
	// Get reCAPTCHA response
	$token = $_POST['g-recaptcha-response'];
	// Validate token
	if(!grecaptcha_verify($token)) {
		return new WP_Error('invalid_recaptcha', '<strong>'.__('ERROR', 'grecaptcha').'</strong>: '.__('reCAPTCHA validation error, try again.', 'grecaptcha'));
	}
	return $errors;
}
add_filter('registration_errors', 'grecaptcha_validate_register_form', 99, 3);
