<?php
/**
 * Add reCAPTCHA to Contact Form 7
 */

if(!defined('ABSPATH')) {
	exit;
}

// Hide reCAPTCHA for logged in users
function grecaptcha_wpcf7_verify_nonce() {
	return is_user_logged_in();
}
add_filter('wpcf7_verify_nonce', 'grecaptcha_wpcf7_verify_nonce');

// Load WPCF7 JS and CSS only when it is necessary
function grecaptcha_wpcf7_fix_loading() {
	global $post;
	if(is_a($post, 'WP_Post') && has_shortcode($post->post_content, 'contact-form-7')) {
		return true;
	}
	return false;
}
add_filter('wpcf7_load_js', 'grecaptcha_wpcf7_fix_loading');
add_filter('wpcf7_load_css', 'grecaptcha_wpcf7_fix_loading');

// Add grecaptcha tag
function grecaptcha_wpcf7_add_tag() {
	wpcf7_add_form_tag(
		'grecaptcha',
		'grecaptcha_wpcf7_tag_handler',
		array('name-attr' => true)
	);
	add_filter('wpcf7_validate_grecaptcha', 'grecaptcha_wpcf7_validate', 10, 2);
}
add_action('wpcf7_init', 'grecaptcha_wpcf7_add_tag');

// Enqueue reCAPTCHA inline scripts
function grecaptcha_wpcf7_enqueue_inline_scripts() {
	// Additional reset function
	$additional = array(
		'v2_checkbox' => "document.addEventListener('wpcf7submit', function() {
				grecaptcha.reset(document.querySelector('.wpcf7-form #g-recaptcha'));
			});",
		'v2_invisible' => "document.addEventListener('wpcf7submit', function() {
				grecaptcha.reset(document.querySelector('.wpcf7-form #g-recaptcha'));
			});",
		'v3' => "document.addEventListener('wpcf7submit', function() {
				document.querySelector('.wpcf7-form #g-recaptcha-response').value = '';
			});"
	);
	grecaptcha_enqueue_inline_scripts('.wpcf7-form', true, $additional);
}

// Enqueue reCAPTCHA scripts
function grecaptcha_wpcf7_enqueue_scripts() {
	add_action('wp_print_footer_scripts', 'grecaptcha_wpcf7_enqueue_inline_scripts');
}
add_action('wpcf7_enqueue_scripts', 'grecaptcha_wpcf7_enqueue_scripts');

// Return reCAPTCHA field on tag handler
function grecaptcha_wpcf7_tag_handler($tag) {
	return grecaptcha_field(sprintf('<span class="wpcf7-form-control-wrap %s"></span>', $tag->name));
}

// Validate reCAPTCHA
function grecaptcha_wpcf7_validate($result, $tag) {
	// Get reCAPTCHA response
	$token = $_POST['g-recaptcha-response'];
	// Validate token
	if(!grecaptcha_verify($token)) {
		$result->invalidate($tag, __('reCAPTCHA validation error, try again.', 'grecaptcha'));
	}
	return $result;
}
