<?php
/**
 * Core functions
 */

if(!defined('ABSPATH')) {
	exit;
}

// Enqueue reCAPTCHA inline scripts
function grecaptcha_enqueue_inline_scripts($element, $ajax = false, $additional = array()) {
	// Hide reCAPTCHA for logged in users
	if(is_user_logged_in()) { return; }
	// Get reCAPTCHA required options
	$site_key = get_option('grecaptcha_site_key');
	$secret_key = get_option('grecaptcha_secret_key');
	// reCAPTCHA is configured
	if($site_key && $secret_key) {
		// Switch between the selected reCAPTCHA version
		switch(get_option('grecaptcha_version')) {
		// reCAPTCHA v2 Checkbox
		case 'v2_checkbox':
			// Auto theme script
			$theme = "";
			if(get_option('grecaptcha_theme', 'auto') == 'auto') {
				$theme = "if(window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
					document.querySelector('$element #g-recaptcha').setAttribute('data-theme', 'dark');
				}
				else {
					document.querySelector('$element #g-recaptcha').setAttribute('data-theme', 'light');
				}";
			}
			$script = "<script type='text/javascript'>
				function grecaptcha_loaded() {
					".$theme."
					grecaptcha.render(document.querySelector('$element #g-recaptcha'));
					".$additional['v2_checkbox']."
				}
			</script>
			<script src='https://www.google.com/recaptcha/api.js?onload=grecaptcha_loaded&render=explicit' async defer></script>";
			break;
		// reCAPTCHA v2 Invisible
		case 'v2_invisible':
			// Auto theme script
			$theme = "";
			if(get_option('grecaptcha_theme', 'auto') == 'auto') {
				$theme = "if(window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
					document.querySelector('$element #g-recaptcha').setAttribute('data-theme', 'dark');
				}
				else {
					document.querySelector('$element #g-recaptcha').setAttribute('data-theme', 'light');
				}";
			}
			// Ajax submit workaround
			if($ajax) {
				$ajax = "document.querySelector('$element').dispatchEvent(
						new Event('submit', {
							'bubbles': true,
							'cancelable': true
						})
					);";
			}
			else {
				$ajax = "document.querySelector('$element').submit();";
			}
			$script = "<script type='text/javascript'>
				function grecaptcha_loaded() {
					".$theme."
					var recaptcha = grecaptcha.render(document.querySelector('$element #g-recaptcha'));
					document.addEventListener('submit', function(event) {
						if(event.target == document.querySelector('$element')) {
							if(!document.querySelector('$element #g-recaptcha-response').value) {
								event.stopPropagation();
								event.preventDefault();
								grecaptcha.execute(recaptcha);
							}
						}
					}, true);
					".$additional['v2_invisible']."
				}
				function grecaptcha_callback() {
					$ajax
				}
			</script>
			<script src='https://www.google.com/recaptcha/api.js?onload=grecaptcha_loaded&render=explicit' async defer></script>";
			break;
		// reCAPTCHA v3
		case 'v3':
			// Ajax submit workaround
			if($ajax) {
				$ajax = "document.querySelector('$element').dispatchEvent(
						new Event('submit', {
							'bubbles': true,
							'cancelable': true
						})
					);";
			}
			else {
				$ajax = "document.querySelector('$element').submit();";
			}
			$script = "<script type='text/javascript'>
				function grecaptcha_loaded() {
					document.addEventListener('submit', function(event) {
						if(event.target == document.querySelector('$element')) {
							if(!document.querySelector('$element #g-recaptcha-response').value) {
								event.stopPropagation();
								event.preventDefault();
								grecaptcha.execute('$site_key', {action: '".preg_replace('/[^A-Za-z0-9 ]/', '', $element)."'}).then(function(token) {
									document.querySelector('$element #g-recaptcha-response').value = token;
									$ajax
								});
							}
						}
					}, true);
					".$additional['v3']."
				}
			</script>
			<script src='https://www.google.com/recaptcha/api.js?onload=grecaptcha_loaded&render=$site_key' async defer></script>";
			break;
		}
		// Display minified script for better compatibility with cache plugins
		echo \JShrink\Minifier::minify($script);
	}
}

function grecaptcha_field($additional = '') {
	// Hide reCAPTCHA for logged in users
	if(is_user_logged_in()) { return; }
	// Switch between the selected reCAPTCHA version
	switch(get_option('grecaptcha_version')) {
	// reCAPTCHA v2 Checkbox
	case 'v2_checkbox':
		$field = '<p id="g-recaptcha" class="g-recaptcha" '.
			'data-sitekey="'.get_option('grecaptcha_site_key').'" '.
			'data-theme="'.get_option('grecaptcha_theme', 'auto').'" '.
			'data-size="'.get_option('grecaptcha_v2_size', 'normal').'"></p>';
		break;
	// reCAPTCHA v2 Invisible
	case 'v2_invisible':
		$field = '<p id="g-recaptcha" class="g-recaptcha" '.
			'data-sitekey="'.get_option('grecaptcha_site_key').'" '.
			'data-theme="'.get_option('grecaptcha_theme', 'auto').'" '.
			'data-badge="'.get_option('grecaptcha_v2_badge', 'bottomright').'" '.
			'data-size="invisible" '.
			'data-callback="grecaptcha_callback"></p>';
		break;
	// reCAPTCHA v3
	case 'v3':
		$field = '<input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response" value="" />';
		break;
	}
	return $field.$additional;
}

// Verifying the user's response
function grecaptcha_verify($token) {
	// Hide reCAPTCHA for logged in users
	if(is_user_logged_in()) { return true; }
	// Get reCAPTCHA required options
	$site_key = get_option('grecaptcha_site_key');
	$secret_key = get_option('grecaptcha_secret_key');
	// reCAPTCHA is configured
	if($site_key && $secret_key) {
		// POST arguments
		$args = array(
			'body' => array(
				'secret' => $secret_key,
				'response' => $token,
				'remoteip' => $_SERVER['REMOTE_ADDR']
			),
			'redirection' => 0,
			'httpversion' => '1.1'
		);
		// POST data
		$response = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', $args);
		if(is_wp_error($response)) { return false; }
		else {
			switch(get_option('grecaptcha_version')) {
				// reCAPTCHA v3
				case 'v3':
					if(json_decode($response['body'])->success == false) return false;
					else if(json_decode($response['body'])->score >= get_option('grecaptcha_v3_threshold', 0.5)) return true;
					else return false;
					break;
				// Other versions
				default:
					return json_decode($response['body'])->success;
					break;
			}
		}
	}
	return true;
}
