<?php
/**
 * Plugin Name: GreCAPTCHA
 * Plugin URI: https://beherit.pl/en/wordpress/grecaptcha/
 * Description: Protects WordPress website forms from spam and brute-force attacks with Google reCAPTCHA.
 * Version: 1.4
 * Requires at least: 4.9
 * Requires PHP: 7.0
 * Author: Krzysztof Grochocki
 * Author URI: https://beherit.pl/
 * Text Domain: grecaptcha
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 */

if(!defined('ABSPATH')) {
	exit;
}

// Define variables
define('GRECAPTCHA_BASENAME', plugin_basename(__FILE__));
define('GRECAPTCHA_DIR', plugin_dir_path(__FILE__));

// Load necessary files
require_once GRECAPTCHA_DIR.'includes/settings.php';
require_once GRECAPTCHA_DIR.'includes/core.php';
require_once GRECAPTCHA_DIR.'includes/lcf.php';
require_once GRECAPTCHA_DIR.'includes/login.php';
require_once GRECAPTCHA_DIR.'includes/comments.php';
require_once GRECAPTCHA_DIR.'includes/wpcf7.php';

// Load external libraries
function grecaptcha_autoload($class_name) {
	if(in_array($class_name, array('JShrink\Minifier'))) {
		require_once GRECAPTCHA_DIR.'third-party/JShrink/Minifier.php';
	}
}
spl_autoload_register('grecaptcha_autoload');
