// Get URL parameter
function GetURLParameter(sParam) {
	var sPageURL = window.location.search.substring(1);
	var sURLVariables = sPageURL.split('&');
	for (var i = 0; i < sURLVariables.length; i++) {
		var sParameterName = sURLVariables[i].split('=');
		if (sParameterName[0] == sParam) {
			return sParameterName[1];
		}
	}
}

// Dispatch an event
function DispatchEvent(name) {
	document.querySelector('.ejabat').dispatchEvent(
		new CustomEvent('ejabat_'+name, {
			'bubbles': true,
			'cancelable': true
		})
	);
}

// Validate input
function ValidateInput(input) {
	// Valid
	if(input.value) {
		input.removeAttribute('class');
		input.classList.add('valid');
		input.parentNode.querySelector('.ejabat-tip').innerText = '';
	}
	// Invalid
	else {
		input.removeAttribute('class');
		input.classList.add('invalid');
		input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.empty_field;
	}
}

// Validate username
function ValidateInputUsername(username, host) {
	// Get tip field
	var tip = username.parentNode.querySelector('.ejabat-tip');
	// Add tip
	tip.innerHTML = ejabat.checking_username;
	// Get username
	if(username.value) {
		var username_regexp = new RegExp(ejabat.username_regexp);
		// Invalid
		if(!username_regexp.test(username.value)) {
			username.removeAttribute('class');
			username.classList.add('invalid');
			tip.innerText = ejabat.invalid_username;
		}
		else {
			// Check if an account exists or not
			var xhr = new XMLHttpRequest();
			xhr.open('POST', ejabat.rest_api + 'check-account', true);
			xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
			xhr.responseType = 'json';
			xhr.onload = function() {
				// Request success
				if(this.status == 200) {
					// Valid
					if(this.response.status == 'success') {
						username.removeAttribute('class');
						username.classList.add('valid');
						tip.innerText = '';
					}
					// Invalid
					else {
						username.removeAttribute('class');
						username.classList.add('invalid');
						tip.innerText = this.response.message;
					}
				}
				// Request error
				else {
					username.removeAttribute('class');
					username.classList.add('invalid');
					tip.innerText = ejabat.error;
				}
			};
			xhr.send('username=' + username.value + '&host=' + host.value);
		}
	}
	// Empty field
	else {
		username.removeAttribute('class');
		username.classList.add('invalid');
		tip.innerText = ejabat.empty_field;
	}
}

// Validate password strength
function ValidateInputStrength(input) {
	// Empty field
	if(!input.value) {
		input.removeAttribute('class');
		input.classList.add('invalid');
		input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.empty_field;
	}
	// Password strength validation
	else if(ejabat.password_strength > 0) {
		// Get the password strength
		if(typeof window.zxcvbn !== 'undefined') var score = zxcvbn(input.value).score;
		// Too week password
		if(score == 0) {
			input.removeAttribute('class');
			input.classList.add('too-weak');
			input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.password_too_weak;
		}
		// Very week password
		if(score == 1) {
			input.removeAttribute('class');
			input.classList.add('very-weak');
			input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.password_very_weak;
		}
		// Week password
		else if(score == 2) {
			input.removeAttribute('class');
			input.classList.add('weak');
			input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.password_weak;
		}
		// Good password
		else if(score == 3) {
			input.removeAttribute('class');
			input.classList.add('good');
			input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.password_good;
		}
		// Strong password
		else if(score == 4) {
			input.removeAttribute('class');
			input.classList.add('strong');
			input.parentNode.querySelector('.ejabat-tip').innerText = ejabat.password_strong;
		}
		// Check password strength
		if(ejabat.password_strength <= score) {
			input.classList.add('valid');
		}
		else {
			input.classList.add('invalid');
		}
	}
	// No password strength validation
	else {
		input.classList.add('valid');
		input.parentNode.querySelector('.ejabat-tip').innerText = '';
	}
}

// Validate email
function ValidateInputEmail(input) {
	// Get tip field
	var tip = input.parentNode.querySelector('.ejabat-tip');
	// Add tip
	tip.innerHTML = ejabat.checking_email;
	// Get email
	if(input.value) {
		var email_regexp = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);
		// Invalid
		if(!email_regexp.test(input.value)) {
			input.removeAttribute('class');
			input.classList.add('invalid');
			tip.innerText = ejabat.invalid_email;
		}
		else {
			var xhr = new XMLHttpRequest();
			xhr.open('POST', ejabat.rest_api + 'validate-email', true);
			xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
			xhr.responseType = 'json';
			xhr.onload = function() {
				// Request success
				if(this.status == 200) {
					// Valid
					if(this.response.status == 'success') {
						input.removeAttribute('class');
						input.classList.add('valid');
						tip.innerText = '';
					}
					// Invalid
					else {
						// Check email in usercheck.com
						var pizza = new XMLHttpRequest();
						pizza.open('GET', 'https://api.usercheck.com/email/' + encodeURIComponent(input.value), true);
						pizza.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
						pizza.responseType = 'json';
						pizza.onload = function() {
							// Request success
							if(this.status == 200) {
								// Did you mean
								if(this.response.did_you_mean != null) {
									input.removeAttribute('class');
									input.classList.add('invalid');
									tip.innerText = ejabat.invalid_email + ' ' + ejabat.did_you_mean + ' ' + this.response.did_you_mean + '?';
								}
								else {
									input.removeAttribute('class');
									input.classList.add('invalid');
									tip.innerText = ejabat.invalid_email;
								}
							}
							// Request error
							else {
								input.removeAttribute('class');
								input.classList.add('invalid');
								tip.innerText = ejabat.invalid_email;
							}
						};
						pizza.send();
					}
				}
				// Request error
				else {
					input.removeAttribute('class');
					input.classList.add('invalid');
					tip.innerText = ejabat.error;
				}
			};
			xhr.send('email=' + encodeURIComponent(input.value));
		}
	}
	// Empty field
	else {
		input.removeAttribute('class');
		input.classList.add('invalid');
		tip.innerText = ejabat.empty_field;
	}
}

document.addEventListener('DOMContentLoaded', function() {
	// Get session cookie
	if(typeof Cookies !== 'undefined') {
		var session = Cookies.get('ejabat_session');
	}
	// Load form
	var xhr = new XMLHttpRequest();
	xhr.open('POST', ejabat.rest_api + document.querySelector('.ejabat').getAttribute('data-action'), true);
	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
	if(ejabat.nonce) xhr.setRequestHeader('X-WP-Nonce', ejabat.nonce);
	xhr.responseType = 'json';
	xhr.onload = function() {
		// Request success
		if(this.status == 200) {
			// Delete old cookie
			if(typeof Cookies !== 'undefined') {
				if(this.response.session == 'expired') {
					Cookies.remove('ejabat_session');
				}
			}
			// Add form to container
			document.querySelector('.ejabat').outerHTML = this.response.data;
			// Save nonce
			var nonce = this.response.nonce;
			// Dispatch an loaded event
			DispatchEvent('loaded');
			//Hints
			document.querySelectorAll('.ejabat-hint input').forEach(function(item) {
				item.addEventListener('focusin', function() {
					var tip = item.parentNode.querySelector('.ejabat-tip');
					if(!tip.innerText) tip.innerText = ejabat[item.name + '_hint'];
				});
				item.addEventListener('focusout', function() {
					var tip = item.parentNode.querySelector('.ejabat-tip');
					if(tip.innerText == ejabat[item.name + '_hint']) tip.innerText = '';
				});
			});
			// Color picker
			document.querySelectorAll('.ejabat-color').forEach(function(item) {
				var hueb = new Huebee(item, {
					notation: 'hex',
					saturations: 2,
					customColors: ['#4CAF50', '#8BC34A', '#795548', '#607D8B', '#F44336', '#9E9E9E']
				});
			});
			// Validate username
			if(document.querySelector('#username.ejabat-validate input')) {
				document.querySelector('#username.ejabat-validate input').addEventListener('change', function() {
					this.value = this.value.toLowerCase().trim();
					ValidateInputUsername(this, document.querySelector('.ejabat #host select'));
				});
				document.querySelector('.ejabat #host select').addEventListener('change', function() {
					ValidateInputUsername(document.querySelector('#username.ejabat-validate input'), this);
				});
			}
			// Validate login
			if(document.querySelector('#login.ejabat-validate input')) {
				document.querySelector('#login.ejabat-validate input').addEventListener('change', function() {
					this.value = this.value.toLowerCase().trim();
					ValidateInput(this);
				});
			}
			// Validate password
			if(document.querySelector('#password.ejabat-strength.ejabat-validate input')) {
				document.querySelector('#password.ejabat-strength.ejabat-validate input').addEventListener('keyup', function(event) {
					var charCode = event.which || event.keyCode;
					if(!((charCode === 9) || (charCode === 16))) {
						ValidateInputStrength(this);
					}
				});
			}
			if(document.querySelector('#password.ejabat-validate:not(.ejabat-strength) input')) {
				document.querySelector('#password.ejabat-validate input').addEventListener('change', function() {
					ValidateInput(this);
				});
			}
			// Validate email
			if(document.querySelector('#email.ejabat-validate input')) {
				document.querySelector('#email.ejabat-validate input').addEventListener('change', function() {
					ValidateInputEmail(this);
				});
			}
			// Submit form
			document.querySelector('.ejabat').addEventListener('submit', function() {
				// Remove all messages
				if(document.querySelector('.ejabat #message')) {
					document.querySelector('.ejabat #message').remove();
				}
				document.querySelector('.ejabat #response').removeAttribute('class');
				document.querySelector('.ejabat #response').innerText = '';
				// Show spinner
				document.querySelector('.ejabat-spinner').style.visibility = 'visible';
				// Validate all inputs
				document.querySelectorAll('.ejabat-validate input').forEach(function(item) {
					ValidateInput(item);
				});
				// Validation errors
				if(document.querySelectorAll('.ejabat input.invalid').length) {
					// Add error response message
					document.querySelector('.ejabat #response').classList.add('ejabat-blocked');
					document.querySelector('.ejabat #response').innerText = ejabat.empty_fields;
					// Hide spinner
					document.querySelector('.ejabat-spinner').style.visibility = 'hidden';
				}
				else {
					var request = new XMLHttpRequest();
					request.open('POST', ejabat.rest_api + document.querySelector('.ejabat').getAttribute('data-action'), true);
					request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
					request.setRequestHeader('X-WP-Nonce', nonce);
					request.responseType = 'json';
					request.onload = function() {
						// Dispatch an submitted event
						DispatchEvent('submitted');
						// Request success
						if(this.status == 200) {
							// Success
							if(this.response.status == 'success') {
								if(typeof Cookies !== 'undefined') {
									// Delete old cookie
									if(this.response.session == 'expired') {
										// Delete cookie
										Cookies.remove('ejabat_session');
										// Reload page
										location.reload();
									}
									// Save new cookie
									else if(this.response.session) {
										// Set cookie
										Cookies.set('ejabat_session', this.response.session, { secure: true, expires: 1/48 });
										// Reload page
										location.reload();
									}
								}
								else {
									document.querySelector('.ejabat').reset();
									document.querySelectorAll('.ejabat input').forEach(function(item) {
										item.removeAttribute('class');
									});
								}
							}
							// Error
							else {
								DispatchEvent('submit_error');
								if(this.response.fields) {
									this.response.fields.forEach(function(item) {
										document.querySelector('.ejabat #'+item+' input').removeAttribute('class');
										document.querySelector('.ejabat #'+item+' input').classList.add('invalid');
									});
								}
							}
							document.querySelector('.ejabat #response').classList.add('ejabat-'+this.response.status);
							document.querySelector('.ejabat #response').innerText = this.response.message;
						}
						// Request error
						else {
							DispatchEvent('request_error');
							// Add error response message
							document.querySelector('.ejabat #response').classList.add('ejabat-error');
							document.querySelector('.ejabat #response').innerText = ejabat.error;
						}
						// Hide spinner
						document.querySelector('.ejabat-spinner').style.visibility = 'hidden';
					}
					request.send(new URLSearchParams(new FormData(document.querySelector('.ejabat'))));
				}
			});
			// Submit logout
			if(document.querySelector('.ejabat-logout')) {
				document.querySelector('.ejabat-logout a').addEventListener('click', function() {
					// Show spinner
					document.querySelector('.ejabat-spinner').style.visibility = 'visible';
					// Delete cookie
					Cookies.remove('ejabat_session');
					// Logout on backend
					var request = new XMLHttpRequest();
					request.open('POST', ejabat.rest_api + 'logout', true);
					request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
					request.setRequestHeader('X-WP-Nonce', nonce);
					request.responseType = 'json';
					request.send('session=' + session);
				});
			}
		}
		// Request error
		else {
			document.querySelector('.ejabat').outerHTML = ejabat.form_error;
		}
	};
	xhr.send('host=' + GetURLParameter('host') + '&code=' + GetURLParameter('code') + '&session=' + session);
});