<?php
/**
 * General settings
 */

if(!defined('ABSPATH')) {
	exit;
}

// Register settings
function ejabat_register_settings() {
	register_setting('ejabat_settings', 'ejabat_show_hints', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_username_hint', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_password_hint', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_email_hint', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_password_strength', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_validator_pizza', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_loader', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_rest_url', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_login', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_password', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_oauth_token', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_debug', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_registration_hosts', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_allowed_username_regexp', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_blocked_username_regexp', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_welcome_msg', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_welcome_msg_subject', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_welcome_msg_body', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_watcher', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_watch_registration', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_watch_activation', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_registration_timeout', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_two_step_registration', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_activation_timeout', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_disable_registration', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_change_email_timeout', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_watch_email_changes', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_disable_change_email', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_reset_pass_timeout', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_reset_pass_limit_count', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_reset_pass_limit_timeout', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_watch_reset_pass', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_disable_reset_pass', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_delete_account_timeout', array('type' => 'integer', 'sanitize_callback' => 'intval'));
	register_setting('ejabat_settings', 'ejabat_watch_delete_account', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_disable_delete_account', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
	register_setting('ejabat_settings', 'ejabat_webpresence_url', array('type' => 'string', 'sanitize_callback' => 'trim'));
	register_setting('ejabat_settings', 'ejabat_disable_webpresence', array('type' => 'boolean', 'sanitize_callback' => 'boolval'));
}
add_action('admin_init', 'ejabat_register_settings');

// Add link to the settings on plugins page
function ejabat_plugin_action_links($links) {
	$links[] = '<a href="admin.php?page=ejabat-settings">'.__('Settings', 'ejabberd-account-tools').'</a>';
	return $links;
}
add_filter('plugin_action_links_'.EJABAT_BASENAME, 'ejabat_plugin_action_links', 10, 2);

// Create settings menu
function ejabat_add_admin_settings() {
	// Add menu page
	add_menu_page('Ejabberd Account Tools', 'Ejabberd Account Tools', 'manage_options', 'ejabat-settings', '', 'dashicons-ejabberd');
	// Add icon CSS style
	add_action('admin_head', 'ejabat_admin_head_icon');
	// Add options page
	if($page_hook = add_submenu_page('ejabat-settings', 'Ejabberd Account Tools - '.__('Settings', 'ejabberd-account-tools'), __('Settings', 'ejabberd-account-tools'), 'manage_options', 'ejabat-settings', 'ejabat_settings_page')) {
		// Add CSS style
		add_action('admin_head-'.$page_hook, 'ejabat_admin_css');
		// Add JS script
		add_action('admin_footer-'.$page_hook, 'ejabat_admin_settings_js');
	}
}
add_action('admin_menu', 'ejabat_add_admin_settings');

// Head icon CSS style
function ejabat_admin_head_icon() { ?>
	<style>
		.dashicons-ejabberd:before{
		content: "\f339";
		transform:rotate(25deg);
		-webkit-transform:rotate(25deg);
		-moz-transform:rotate(25deg);
		-o-transform:rotate(25deg);
		}
	</style>
<?php }

// CSS style
function ejabat_admin_css() { ?>
	<style>
		.ejabberd-account-tools_page_ejabat-tools .form-table th{
		width:44px;
		}
		.form-table.sub-table th{
		font-weight:normal;
		}
		.metabox-holder .postbox .hndle{
		cursor:default;
		}
		.postbox.opened .hndle, .postbox.closed .hndle{
		cursor:pointer;
		}
		.rating-stars{
		text-align:center;
		}
		.rating-stars a{
		color:#ffb900;
		text-decoration:none;
		}
	</style>
<?php }

// JS script
function ejabat_admin_settings_js() { ?>
	<script type="text/javascript">
		document.addEventListener('DOMContentLoaded', function() {
			// Add toggles to postboxes
			document.querySelector('.postbox.closed .handlediv').addEventListener('click', function() {
				this.parentElement.parentElement.parentElement.classList.toggle('closed');
				this.parentElement.parentElement.parentElement.classList.toggle('opened');
			});
			document.querySelector('.postbox.closed .hndle').addEventListener('click', function() {
				this.parentElement.parentElement.classList.toggle('closed');
				this.parentElement.parentElement.classList.toggle('opened');
			});
		});
	</script>
<?php }

// Display notices
function ejabat_admin_notices() {
	if(isset($_GET['page']) && isset($_GET['settings-updated'])) {
		// Re-enable registration
		if(($_GET['page']=='ejabat-settings') && ($_GET['settings-updated']=='enable-registration')) {
			update_option('ejabat_disable_registration', false);
		}
		// Re-enable form to change private email address
		if(($_GET['page']=='ejabat-settings') && ($_GET['settings-updated']=='enable-change-email')) {
			update_option('ejabat_disable_change_email', false);
		}
		// Re-enable form to reset password
		if(($_GET['page']=='ejabat-settings') && ($_GET['settings-updated']=='enable-reset-pass')) {
			update_option('ejabat_disable_reset_pass', false);
		}
		// Re-enable form to delete account
		if(($_GET['page']=='ejabat-settings') && ($_GET['settings-updated']=='enable-delete-account')) {
			update_option('ejabat_disable_delete_account', false);
		}
		// Re-enable Web Presence configuration form
		if(($_GET['page']=='ejabat-settings') && ($_GET['settings-updated']=='enable-web-presence')) {
			update_option('ejabat_disable_webpresence', false);
		}
		// Disable debug mode
		if(($_GET['page']=='ejabat-settings') && ($_GET['settings-updated']=='disable-debug')) {
			update_option('ejabat_debug', false);
		}
	}
	// Display notice - registration
	if(get_option('ejabat_disable_registration', false)) {
		echo '<div class="notice notice-warning"><p><strong>Ejabberd Account Tools</strong>: ' . sprintf(__('Registration is temporarily disabled, click <a href="%s">here</a> to re-enable it.', 'ejabberd-account-tools'), admin_url('admin.php?page=ejabat-settings&settings-updated=enable-registration')) . '</p></div>';
	}
	// Display notice - form to change private email address
	if(get_option('ejabat_disable_change_email', false)) {
		echo '<div class="notice notice-warning"><p><strong>Ejabberd Account Tools</strong>: ' . sprintf(__('Form to change private email address is temporarily disabled, click <a href="%s">here</a> to re-enable it.', 'ejabberd-account-tools'), admin_url('admin.php?page=ejabat-settings&settings-updated=enable-change-email')) . '</p></div>';
	}
	// Display notice - form to reset password
	if(get_option('ejabat_disable_reset_pass', false)) {
		echo '<div class="notice notice-warning"><p><strong>Ejabberd Account Tools</strong>: ' . sprintf(__('Form to reset password is temporarily disabled, click <a href="%s">here</a> to re-enable it.', 'ejabberd-account-tools'), admin_url('admin.php?page=ejabat-settings&settings-updated=enable-reset-pass')) . '</p></div>';
	}
	// Display notice - form to delete account
	if(get_option('ejabat_disable_delete_account', false)) {
		echo '<div class="notice notice-warning"><p><strong>Ejabberd Account Tools</strong>: ' . sprintf(__('Form to delete account is temporarily disabled, click <a href="%s">here</a> to re-enable it.', 'ejabberd-account-tools'), admin_url('admin.php?page=ejabat-settings&settings-updated=enable-delete-account')) . '</p></div>';
	}
	// Display notice - Web Presence configuration form
	if(get_option('ejabat_disable_webpresence', false)) {
		echo '<div class="notice notice-warning"><p><strong>Ejabberd Account Tools</strong>: ' . sprintf(__('Web Presence configuration form is temporarily disabled, click <a href="%s">here</a> to re-enable it.', 'ejabberd-account-tools'), admin_url('admin.php?page=ejabat-settings&settings-updated=enable-web-presence')) . '</p></div>';
	}
	// Display notice - degub mode
	if(get_option('ejabat_debug', false)) {
		echo '<div class="notice notice-warning"><p><strong>Ejabberd Account Tools</strong>: ' . sprintf(__('Debug mode is enabled, click <a href="%s">here</a> to disable it.', 'ejabberd-account-tools'), admin_url('admin.php?page=ejabat-settings&settings-updated=disable-debug')) . '</p></div>';
	}
}
add_action('admin_notices', 'ejabat_admin_notices');

// Display options page
function ejabat_settings_page() { ?>
	<div class="wrap">
		<h1 class="wp-heading-inline">Ejabberd Account Tools - <?php _e('Settings', 'ejabberd-account-tools'); ?></h1>
		<?php settings_errors();
		if(isset($_POST['clear_cache'])) {
			// Clear cache
			$callback = ejabat_clear_cache_admin_callback();
			// Show message
			echo '<div class="notice notice-'.$callback['status'].' is-dismissible"><p><strong>'.$callback['message'].'</strong></p></div>';
		} ?>
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="postbox-container-2" class="postbox-container">
					<div id="normal-sortables" class="meta-box-sortables">
						<form id="ejabat-form" method="post" action="options.php">
							<?php settings_fields('ejabat_settings'); ?>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('ReST API', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('API address', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_rest_url" id="ejabat_rest_url" type="text" size="40" value="<?php echo get_option('ejabat_rest_url'); ?>" />
												<p class="description"><?php _e('Enter the URL address defined for the mod_http_api module in the ejabberd settings.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Login', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_login" id="ejabat_login" type="text" size="40" value="<?php echo get_option('ejabat_login'); ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('Password', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_password" id="ejabat_password" type="password" size="40" autocomplete="new-password" value="<?php echo get_option('ejabat_password'); ?>" />
											</td>
										</tr>
										<tr>
											<th><?php _e('OAuth token', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_oauth_token" id="ejabat_oauth_token" type="text" size="40" value="<?php echo get_option('ejabat_oauth_token'); ?>" />
												<p class="description"><?php printf(__('Use instead of classic login and password access. The plugin doesn\'t generate and check the expiration date of OAuth tokens, so you need to generate OAuth token for your own with a long expiration date. To generate a token, use the oauth_issue_token command with the ejabberdctl shell script e.g.: %s', 'ejabberd-account-tools'), '<kbd>ejabberdctl oauth_issue_token bot@'.preg_replace('/^www\./','',$_SERVER['SERVER_NAME']).' 315360000 ejabberd:admin</kbd>'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Debugging', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_debug"><input name="ejabat_debug" id="ejabat_debug" type="checkbox" value="1" <?php checked(1, get_option('ejabat_debug', false)); ?> /><?php _e('Enable debug mode', 'ejabberd-account-tools'); ?></label>
												<p class="description"><?php _e('Debugging information will be returned in the JSON response.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
									</tbody></table>
								</div>
							</div>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('General', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Tips', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_show_hints"><input name="ejabat_show_hints" id="ejabat_show_hints" type="checkbox" value="1" <?php checked(1, get_option('ejabat_show_hints', true)); ?> /><?php _e('Enable form tips', 'ejabberd-account-tools'); ?></label>
												<p class="description"><?php printf(__('Displays tips in the forms that provide information about field requirements. Use the %s filter to support multiple language.', 'ejabberd-account-tools'), '<kbd>ejabat_hints_args</kbd>'); ?></p>
												<table class="form-table sub-table"><tbody>
													<tr>
														<th><label for="ejabat_username_hint"><?php _e('Username', 'ejabberd-account-tools'); ?></label></th>
														<td>
															<input name="ejabat_username_hint" id="ejabat_username_hint" type="text" size="50" value="<?php echo get_option('ejabat_username_hint', __('At least 3 and up to 30 characters, only letters and numbers.', 'ejabberd-account-tools')); ?>" />
														</td>
													</tr>
													<tr>
														<th><label for="ejabat_password_hint"><?php _e('Password', 'ejabberd-account-tools'); ?></label></th>
														<td>
															<input name="ejabat_password_hint" id="ejabat_password_hint" type="text" size="50" value="<?php echo get_option('ejabat_password_hint', __('At least a good password is required.', 'ejabberd-account-tools')); ?>" />
														</td>
													</tr>
													<tr>
														<th><label for="ejabat_email_hint"><?php _e('Email', 'ejabberd-account-tools'); ?></label></th>
														<td>
															<input name="ejabat_email_hint" id="ejabat_email_hint" type="text" size="50" value="<?php echo get_option('ejabat_email_hint', __('Only required for password recovery.', 'ejabberd-account-tools')); ?>" />
														</td>
													</tr>
												</tbody></table>
											</td>
										</tr>
										<tr>
											<th><?php _e('Password strength', 'ejabberd-account-tools'); ?></th>
											<td>
												<?php $ejabat_password_strength = get_option('ejabat_password_strength', 3); ?>
												<select name="ejabat_password_strength" id="ejabat_password_strength"><option value="0" <?php selected($ejabat_password_strength, 0); ?>><?php _e('Disabled', 'ejabberd-account-tools'); ?></option><option value="1" <?php selected($ejabat_password_strength, 1); ?>><?php _e('Very weak', 'ejabberd-account-tools'); ?></option><option value="2" <?php selected($ejabat_password_strength, 2); ?>><?php _e('Weak', 'ejabberd-account-tools'); ?></option><option value="3" <?php selected($ejabat_password_strength, 3); ?>><?php _e('Good', 'ejabberd-account-tools'); ?></option><option value="4" <?php selected($ejabat_password_strength, 4); ?>><?php _e('Strong', 'ejabberd-account-tools'); ?></option></select>
												<p class="description"><?php _e('The minimum required password strength.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Disposable emails', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_validator_pizza"><input name="ejabat_validator_pizza" id="ejabat_validator_pizza" type="checkbox" value="1" <?php checked(1, get_option('ejabat_validator_pizza', true)); ?> /><?php _e('Block disposable email addresses on all forms', 'ejabberd-account-tools'); ?></label>
												<p class="description"><?php printf(__('Uses %s to validate email addresses.', 'ejabberd-account-tools'), '<a href="https://www.usercheck.com/" target="_blank">UserCheck.com</a>'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Watchers', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_watcher" id="ejabat_watcher" type="text" size="40" value="<?php echo get_option('ejabat_watcher'); ?>" />
												<p class="description"><?php _e('List of JIDs that will be notified of each new registration, activation and many more. Each JID must be separated by a space, leave this field blank to disable it.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Style', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_loader"><input name="ejabat_loader" id="ejabat_loader" type="checkbox" value="1" <?php checked(1, get_option('ejabat_loader', true)); ?> /><?php _e('Show forms loading animation', 'ejabberd-account-tools'); ?></label>
											</td>
										</tr>
									</tbody></table>
								</div>
							</div>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Registration', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Hosts', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_registration_hosts" id="ejabat_registration_hosts" type="text" size="40" value="<?php echo get_option('ejabat_registration_hosts', preg_replace('/^www\./','',$_SERVER['SERVER_NAME'])); ?>" />
												<p class="description"><?php _e('List of hosts available in registration, must be separated by a space.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Allowed username', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_allowed_username_regexp" id="ejabat_allowed_username_regexp" type="text" size="40" value="<?php echo get_option('ejabat_allowed_username_regexp', '^(?=^[a-z0-9].*)(?=.*[a-z0-9]$)(?!.*([_.-])\1+.*)(?!^([0-9]+)$)[a-z0-9_.-]{3,30}$'); ?>" />
												<p class="description"><?php _e('Use only regular expressions.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Blocked username', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_blocked_username_regexp" id="ejabat_blocked_username_regexp" type="text" size="40" value="<?php echo get_option('ejabat_blocked_username_regexp', '^(.*(admin|blog|bot|contact|e-mail|ejabberd|email|ftp|hostmaster|http|https|imap|info|jabber|login|mail|office|owner|pop3|postmaster|root|smtp|ssh|support|team|webmaster|xmpp).*)$'); ?>" />
												<p class="description"><?php _e('Use only regular expressions.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Welcome message', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_welcome_msg"><input name="ejabat_welcome_msg" id="ejabat_welcome_msg" type="checkbox" value="1" <?php checked(1, get_option('ejabat_welcome_msg', false)); ?> /><?php _e('Send a welcome message to a newly registered account', 'ejabberd-account-tools'); ?></label>
												<table class="form-table sub-table"><tbody>
													<tr>
														<th><label for="ejabat_welcome_msg_subject"><?php _e('Subject', 'ejabberd-account-tools'); ?></label></th>
														<td>
															<input name="ejabat_welcome_msg_subject" id="ejabat_welcome_msg_subject" type="text" size="40" value="<?php echo get_option('ejabat_welcome_msg_subject'); ?>" />
															<p class="description"><?php _e('Optionally, it can be empty.', 'ejabberd-account-tools'); ?></p>
														</td>
													</tr>
													<tr>
														<th><label for="ejabat_welcome_msg_body"><?php _e('Body', 'ejabberd-account-tools'); ?></label></th>
														<td>
															<textarea name="ejabat_welcome_msg_body" id="ejabat_welcome_msg_body" cols="65" rows="5" /><?php echo get_option('ejabat_welcome_msg_body'); ?></textarea>
															<p class="description"><?php printf(__('Plain text only, shortcodes allowed. Use the %s filter to support multiple language.', 'ejabberd-account-tools'), '<kbd>ejabat_welcome_msg_args</kbd>'); ?></p>
														</td>
													</tr>
												</tbody></table>
											</td>
										</tr>
										<tr>
											<th><?php _e('Two-step registration', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_two_step_registration"><input name="ejabat_two_step_registration" id="ejabat_two_step_registration" type="checkbox" value="1" <?php checked(1, get_option('ejabat_two_step_registration', false)); ?> /><?php _e('Enable two-step registration', 'ejabberd-account-tools'); ?></label>
												<p class="description"><?php _e('Registration must be confirmed by an activation link sent to a private email address. Until then, the account will be temporarily banned.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Link validity', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_activation_timeout" id="ejabat_activation_timeout" type="number" min="0" max="86400" value="<?php echo get_option('ejabat_activation_timeout', 3600); ?>" />&nbsp;<?php _e('seconds', 'ejabberd-account-tools'); ?>
												<p class="description"><?php _e('Determines how long the activation link is valid. Enter 0 to disable.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Registration time limit', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_registration_timeout" id="ejabat_registration_timeout" type="number" min="0" max="86400" value="<?php echo get_option('ejabat_registration_timeout', 3600); ?>" />&nbsp;<?php _e('seconds', 'ejabberd-account-tools'); ?>
												<p class="description"><?php _e('Limits registration frequency per IP address. Enter 0 to disable.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Notifications', 'ejabberd-account-tools'); ?></th>
											<td>
												<fieldset>
													<label for="ejabat_watch_registration"><input name="ejabat_watch_registration" id="ejabat_watch_registration" type="checkbox" value="1" <?php checked(1, get_option('ejabat_watch_registration', true)); ?> /><?php _e('Send notification of each new registration', 'ejabberd-account-tools'); ?></label>
													<label for="ejabat_watch_activation"><input name="ejabat_watch_activation" id="ejabat_watch_activation" type="checkbox" value="1" <?php checked(1, get_option('ejabat_watch_activation', false)); ?> /><?php _e('Send notification when user activates account', 'ejabberd-account-tools'); ?></label>
												</fieldset>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<label for="ejabat_disable_registration"><input name="ejabat_disable_registration" id="ejabat_disable_registration" type="checkbox" value="1" <?php checked(1, get_option('ejabat_disable_registration', false)); ?> /><?php _e('Temporarily disable registration for not logged in users', 'ejabberd-account-tools'); ?></label>
								</div>
							</div>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Email address change', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Link validity', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_change_email_timeout" id="ejabat_change_email_timeout" type="number" min="0" max="86400" value="<?php echo get_option('ejabat_change_email_timeout', 900); ?>" />&nbsp;<?php _e('seconds', 'ejabberd-account-tools'); ?>
												<p class="description"><?php _e('Defines how long the confirmation link is valid. Enter 0 to disable.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Notifications', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_watch_email_changes"><input name="ejabat_watch_email_changes" id="ejabat_watch_email_changes" type="checkbox" value="1" <?php checked(1, get_option('ejabat_watch_email_changes', false)); ?> /><?php _e('Send notifications about every progress of the private email address change process', 'ejabberd-account-tools'); ?></label>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<label for="ejabat_disable_change_email"><input name="ejabat_disable_change_email" id="ejabat_disable_change_email" type="checkbox" value="1" <?php checked(1, get_option('ejabat_disable_change_email', false)); ?> /><?php _e('Temporarily disable form to change private email address for not logged in users', 'ejabberd-account-tools'); ?></label>
								</div>
							</div>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Password reset', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Link validity', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_reset_pass_timeout" id="ejabat_reset_pass_timeout" type="number" min="0" max="86400" value="<?php echo get_option('ejabat_reset_pass_timeout', 900); ?>" />&nbsp;<?php _e('seconds', 'ejabberd-account-tools'); ?>
												<p class="description"><?php _e('Defines how long the confirmation link is valid. Enter 0 to disable.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Verification limit', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_reset_pass_limit_count" id="ejabat_reset_pass_limit_count" type="number" min="3" max="9" value="<?php echo get_option('ejabat_reset_pass_limit_count', 4); ?>" />&nbsp;<?php _e('within', 'ejabberd-account-tools'); ?>&nbsp;<input type="number" min="0" max="86400" name="ejabat_reset_pass_limit_timeout" value="<?php echo get_option('ejabat_reset_pass_limit_timeout', 43200); ?>" />&nbsp;<?php _e('seconds', 'ejabberd-account-tools'); ?>
												<p class="description"><?php _e('Defines the maximum number of verifications within the specified time. Enter 0 to disable.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Notifications', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_watch_reset_pass"><input name="ejabat_watch_reset_pass" id="ejabat_watch_reset_pass" type="checkbox" value="1" <?php checked(1, get_option('ejabat_watch_reset_pass', false)); ?> /><?php _e('Send notifications about every progress of the password reset process', 'ejabberd-account-tools'); ?></label>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<label for="ejabat_disable_reset_pass"><input name="ejabat_disable_reset_pass" id="ejabat_disable_reset_pass" type="checkbox" value="1" <?php checked(1, get_option('ejabat_disable_reset_pass', false)); ?> /><?php _e('Temporarily disable form to reset password for not logged in users', 'ejabberd-account-tools'); ?></label>
								</div>
							</div>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Deleting an account', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Link validity', 'ejabberd-account-tools'); ?></th>
											<td>
												<input name="ejabat_delete_account_timeout" id="ejabat_delete_account_timeout" type="number" min="0" max="86400" value="<?php echo get_option('ejabat_delete_account_timeout', 900); ?>" />&nbsp;<?php _e('seconds', 'ejabberd-account-tools'); ?>
												<p class="description"><?php _e('Defines how long the confirmation link is valid. Enter 0 to disable.', 'ejabberd-account-tools'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Notifications', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_watch_delete_account"><input name="ejabat_watch_delete_account" id="ejabat_watch_delete_account" type="checkbox" value="1" <?php checked(1, get_option('ejabat_watch_delete_account', false)); ?> /><?php _e('Send notifications about every progress of the deleting account process', 'ejabberd-account-tools'); ?></label>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<label for="ejabat_disable_delete_account"><input name="ejabat_disable_delete_account" id="ejabat_disable_delete_account" type="checkbox" value="1" <?php checked(1, get_option('ejabat_disable_delete_account', false)); ?> /><?php _e('Temporarily disable form to delete account for not logged in users', 'ejabberd-account-tools'); ?></label>
								</div>
							</div>
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle"><?php _e('Web Presence', 'ejabberd-account-tools'); ?></h2>
								</div>
								<div class="inside">
									<table class="form-table"><tbody>
										<tr>
											<th><?php _e('Permalink', 'ejabberd-account-tools'); ?></th>
											<td>
												<label for="ejabat_webpresence_url"><kbd><?php echo rest_url(); ?></kbd><input name="ejabat_webpresence_url" id="ejabat_webpresence_url" type="text" size="8" value="<?php echo get_option('ejabat_webpresence_url', 'presence'); ?>" /><kbd>/%type%/%jid%</kbd></label>
												<p class="description"><?php printf(__('To change the WordPress ReST API prefix please use the %s filter. More information can be found <a href="%s" target="_blank">here</a>.', 'ejabberd-account-tools'), '<kbd>rest_url_prefix</kbd>', 'https://developer.wordpress.org/reference/hooks/rest_url_prefix/'); ?></p>
											</td>
										</tr>
										<tr>
											<th><?php _e('Image file', 'ejabberd-account-tools'); ?></th>
											<td>
												<p class="description"><?php printf(__('You can change the default image files by adding a folder %s with your own images to the active theme. Make sure the file names match the XMPP statuses: %s. You can use any image file format.', 'ejabberd-account-tools'), '<kbd>/webpresence/</kbd>', '<kbd>available</kbd>, <kbd>away</kbd>, <kbd>chat</kbd>, <kbd>dnd</kbd>, <kbd>unavailable</kbd>, <kbd>xa</kbd>'); ?></p>
											</td>
										</tr>
									</tbody></table>
								</div>
								<div id="major-publishing-actions">
									<label for="ejabat_disable_webpresence"><input name="ejabat_disable_webpresence" id="ejabat_disable_webpresence" type="checkbox" value="1" <?php checked(1, get_option('ejabat_disable_webpresence', false)); ?> /><?php _e('Temporarily disable form to configure Web Presence for not logged in users', 'ejabberd-account-tools'); ?></label>
								</div>
							</div>
							<?php submit_button(__('Save settings', 'ejabberd-account-tools'), 'primary', 'submit', false); ?>
							<input formaction="" name="clear_cache" id="clear_cache" type="submit" class="button button-secondary" value="<?php _e('Clear cache', 'ejabberd-account-tools'); ?>" />
						</form>
					</div>
				</div>
				<div id="postbox-container-1" class="postbox-container">
					<div id="side-sortables" class="meta-box-sortables">
						<div class="postbox">
							<div class="inside">
								<p><?php _e('If you like this plugin please give a review at WordPress.org.', 'ejabberd-account-tools'); ?></p>
								<p class="rating-stars"><a href="https://wordpress.org/support/plugin/ejabberd-account-tools/reviews/?rate=5#new-post" target="_blank"><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span></a></p>
							</div>
						</div>
						<div class="postbox closed">
							<div class="postbox-header">
								<h2 class="hndle"><?php _e('Usage information', 'ejabberd-account-tools'); ?></h2>
								<div class="handle-actions hide-if-no-js">
									<button type="button" class="handlediv" aria-expanded="true"><span class="toggle-indicator" aria-hidden="true"></span></button>
								</div>
							</div>
							<div class="inside">
								<p><?php printf(__('Make sure you have the latest version of ejabberd - the plugin requires at least ejabberd %s.', 'ejabberd-account-tools'), '24.06'); ?></p>
								<p><?php printf(__('Check if you have correctly configured the mod_http_api module in ejabberd. Example configuration (more information <a href="%s" target="_blank">here</a>):', 'ejabberd-account-tools'), 'https://docs.ejabberd.im/developer/ejabberd-api/'); ?></p>
<pre style="overflow-x:auto;">listen:
  - ip: "::"
    port: 5285
    module: ejabberd_http
    request_handlers:
      api: mod_http_api

api_permissions:
  "rest api":
    who:
      - user: "bot@<?php echo preg_replace('/^www\./','',$_SERVER['SERVER_NAME']); ?>"
    what:
      - ban_account
      - change_password
      - check_account
      - check_password
      - get_ban_details
      - get_presence
      - get_vcard
      - kick_user
      - private_get
      - private_set
      - register
      - registered_vhosts
      - send_message
      - unban_account
      - unban_ip
      - unregister</pre>
								<p><?php _e('Configure the ReST API address and authorization data, place the shortcodes on some page.', 'ejabberd-account-tools'); ?></p>
								<ul>
									<li><b>[ejabat_register]</b></br><?php _e('Form for registering a new account.', 'ejabberd-account-tools'); ?></br></li>
									<li><b>[ejabat_change_email]</b></br><?php _e('Form for changing / adding a private email address.', 'ejabberd-account-tools'); ?></br></li>
									<li><b>[ejabat_reset_password]</b></br><?php _e('Form for resetting an account password.', 'ejabberd-account-tools'); ?></br></li>
									<li><b>[ejabat_delete_account]</b></br><?php _e('Form for deleting an account.', 'ejabberd-account-tools'); ?></br></li>
									<li><b>[ejabat_webpresence]</b></br><?php _e('Web Presence configuration form.', 'ejabberd-account-tools'); ?></br></li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php }

// Clear cache
function ejabat_clear_cache_admin_callback() {
	// Delete transients
	global $wpdb;
	$wpdb->query("DELETE FROM $wpdb->options WHERE option_name LIKE '_transient_timeout_ejabat_%'");
	$wpdb->query("DELETE FROM $wpdb->options WHERE option_name LIKE '_transient_ejabat_%'");
	// Message
	$status = 'success';
	$message = __('The cache has been successfully cleared.', 'ejabberd-account-tools');
	// Return response
	return array('status' => isset($status) ? $status : 'error', 'message' => isset($message) ? $message : __('An unexpected error occurred. Please try again.', 'ejabberd-account-tools'));
}
