<?php
/**
 * Plugin Name: Ejabberd Account Tools
 * Plugin URI: https://beherit.pl/en/wordpress/ejabberd-account-tools/
 * Description: Provides a set of useful tools for the ejabberd server, both for the frontend and backend spaces
 * Version: 2.11
 * Requires at least: 5.9
 * Requires PHP: 8.0
 * Author: Krzysztof Grochocki
 * Author URI: https://beherit.pl/
 * Text Domain: ejabberd-account-tools
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 */

if(!defined('ABSPATH')) {
	exit;
}

// Define variables
define('EJABAT_VERSION', '2.11');
define('EJABAT_BASENAME', plugin_basename(__FILE__));
define('EJABAT_DIR', plugin_dir_path(__FILE__));
define('EJABAT_DIR_URL', plugin_dir_url(__FILE__));

// Load necessary files
require_once EJABAT_DIR.'includes/admin-settings.php';
require_once EJABAT_DIR.'includes/admin-captcha.php';
require_once EJABAT_DIR.'includes/admin-tools.php';
require_once EJABAT_DIR.'includes/functions.php';
require_once EJABAT_DIR.'includes/cron.php';
require_once EJABAT_DIR.'includes/register.php';
require_once EJABAT_DIR.'includes/change_email.php';
require_once EJABAT_DIR.'includes/delete_account.php';
require_once EJABAT_DIR.'includes/reset_password.php';
require_once EJABAT_DIR.'includes/webpresence.php';
require_once EJABAT_DIR.'includes/captcha.php';

// Load external libraries
function ejabat_autoload($class_name) {
	if(in_array($class_name, array('JShrink\Minifier'))) {
		require_once EJABAT_DIR.'third-party/JShrink/Minifier.php';
	}
	if(in_array($class_name, array('Gregwar\Captcha\CaptchaBuilder'))) {
		require_once EJABAT_DIR.'third-party/Captcha/CaptchaBuilder.php';
	}
	if(in_array($class_name, array('Gregwar\Captcha\CaptchaBuilderInterface'))) {
		require_once EJABAT_DIR.'third-party/Captcha/CaptchaBuilderInterface.php';
	}
	if(in_array($class_name, array('Gregwar\Captcha\PhraseBuilder'))) {
		require_once EJABAT_DIR.'third-party/Captcha/PhraseBuilder.php';
	}
	if(in_array($class_name, array('Gregwar\Captcha\PhraseBuilderInterface'))) {
		require_once EJABAT_DIR.'third-party/Captcha/PhraseBuilderInterface.php';
	}
	if(in_array($class_name, array('Gregwar\Captcha\ImageFileHandler'))) {
		require_once EJABAT_DIR.'third-party/Captcha/ImageFileHandler.php';
	}
}
spl_autoload_register('ejabat_autoload');
