<?php
/**
 * Add reCAPTCHA to Lite Contact Form
 */

if(!defined('ABSPATH')) {
	exit;
}

// Add grecaptcha tag
function grecaptcha_lcf_add_tag() {
	return grecaptcha_field();
}
add_filter('lcf_after_fields', 'grecaptcha_lcf_add_tag');

// Enqueue reCAPTCHA inline scripts
function grecaptcha_lcf_enqueue_inline_scripts() {
	// Additional reset function
	$additional = array(
		'v2_checkbox' => "document.addEventListener('lcf_submitted', function() {
				grecaptcha.reset(document.querySelector('.lcf #g-recaptcha'));
			});",
		'v2_invisible' => "document.addEventListener('lcf_submitted', function() {
				grecaptcha.reset(document.querySelector('.lcf #g-recaptcha'));
			});",
		'v3' => "document.addEventListener('lcf_submitted', function() {
				document.querySelector('.lcf #g-recaptcha-response').value = '';
			});"
	);
	grecaptcha_enqueue_inline_scripts('.lcf', true, $additional);
}

// Enqueue reCAPTCHA scripts
function grecaptcha_lcf_enqueue_scripts() {
	add_action('wp_print_footer_scripts', 'grecaptcha_lcf_enqueue_inline_scripts');
}
add_action('lcf_enqueue_scripts', 'grecaptcha_lcf_enqueue_scripts');

// Validate reCAPTCHA
function grecaptcha_lcf_validate($result, $field, $value) {
	// Validate token
	if(!grecaptcha_verify($value)) {
		$result['status'] = 'blocked';
		$result['message'] = __('reCAPTCHA validation error, try again.', 'grecaptcha');
	}
	return $result;
}
add_filter('lcf_validate_g-recaptcha-response', 'grecaptcha_lcf_validate', 10, 3);
